/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.directory.DirContext;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.DefaultInitialDirContextFactory;
import org.acegisecurity.ldap.LdapDataAccessException;
import org.acegisecurity.ldap.LdapUtils;
import org.springframework.context.MessageSource;

public class DefaultInitialDirContextFactoryTests
extends AbstractLdapServerTestCase {
    DefaultInitialDirContextFactory idf;

    public void onSetUp() {
        this.idf = this.getInitialCtxFactory();
        this.idf.setMessageSource((MessageSource)new AcegiMessageSource());
    }

    public void testAnonymousBindSucceeds() throws Exception {
        DirContext ctx = this.idf.newInitialDirContext();
        ctx.close();
    }

    public void testBaseDnIsParsedFromCorrectlyFromUrl() {
        this.idf = new DefaultInitialDirContextFactory("ldap://acegisecurity.org/dc=acegisecurity,dc=org");
        DefaultInitialDirContextFactoryTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)this.idf.getRootDn());
        this.idf = new DefaultInitialDirContextFactory("ldap://acegisecurity.org/");
        DefaultInitialDirContextFactoryTests.assertEquals((String)"", (String)this.idf.getRootDn());
        this.idf = new DefaultInitialDirContextFactory("ldap://acegisecurity.org");
        DefaultInitialDirContextFactoryTests.assertEquals((String)"", (String)this.idf.getRootDn());
    }

    public void testBindAsManagerFailsIfNoPasswordSet() throws Exception {
        this.idf.setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        DirContext ctx = null;
        try {
            ctx = this.idf.newInitialDirContext();
            DefaultInitialDirContextFactoryTests.fail((String)"Binding with no manager password should fail.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        LdapUtils.closeContext((Context)ctx);
    }

    public void testBindAsManagerSucceeds() throws Exception {
        this.idf.setManagerPassword("acegisecurity");
        this.idf.setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        DirContext ctx = this.idf.newInitialDirContext();
        ctx.close();
    }

    public void testConnectionAsSpecificUserSucceeds() throws Exception {
        DirContext ctx = this.idf.newInitialDirContext("uid=Bob,ou=people,dc=acegisecurity,dc=org", "bobspassword");
        ctx.close();
    }

    public void testConnectionFailure() throws Exception {
        this.idf = new DefaultInitialDirContextFactory("ldap://localhost:60389");
        this.idf.setInitialContextFactory("com.sun.jndi.ldap.LdapCtxFactory");
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("com.sun.jndi.ldap.connect.timeout", "200");
        this.idf.setExtraEnvVars(env);
        this.idf.setUseConnectionPool(false);
        try {
            this.idf.newInitialDirContext();
            DefaultInitialDirContextFactoryTests.fail((String)"Connection succeeded unexpectedly");
        }
        catch (LdapDataAccessException ldapDataAccessException) {
            // empty catch block
        }
    }

    public void testEnvironment() {
        this.idf = new DefaultInitialDirContextFactory("ldap://acegisecurity.org/");
        Hashtable env = this.idf.getEnvironment();
        DefaultInitialDirContextFactoryTests.assertEquals((Object)"ldap://acegisecurity.org/", env.get("java.naming.provider.url"));
        DefaultInitialDirContextFactoryTests.assertEquals((Object)"simple", env.get("java.naming.security.authentication"));
        DefaultInitialDirContextFactoryTests.assertNull(env.get("java.naming.security.principal"));
        DefaultInitialDirContextFactoryTests.assertNull(env.get("java.naming.security.credentials"));
        this.idf.setInitialContextFactory("org.acegisecurity.NonExistentCtxFactory");
        env = this.idf.getEnvironment();
        DefaultInitialDirContextFactoryTests.assertEquals((Object)"org.acegisecurity.NonExistentCtxFactory", env.get("java.naming.factory.initial"));
        this.idf.setAuthenticationType("myauthtype");
        env = this.idf.getEnvironment();
        DefaultInitialDirContextFactoryTests.assertEquals((Object)"myauthtype", env.get("java.naming.security.authentication"));
        Hashtable<String, String> extraVars = new Hashtable<String, String>();
        extraVars.put("extravar", "extravarvalue");
        this.idf.setExtraEnvVars(extraVars);
        env = this.idf.getEnvironment();
        DefaultInitialDirContextFactoryTests.assertEquals((Object)"extravarvalue", env.get("extravar"));
    }

    public void testInvalidPasswordCausesBadCredentialsException() throws Exception {
        this.idf.setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        this.idf.setManagerPassword("wrongpassword");
        DirContext ctx = null;
        try {
            ctx = this.idf.newInitialDirContext();
            DefaultInitialDirContextFactoryTests.fail((String)"Binding with wrong credentials should fail.");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        LdapUtils.closeContext((Context)ctx);
    }

    public void testMultipleProviderUrlsAreAccepted() {
        this.idf = new DefaultInitialDirContextFactory("ldaps://acegisecurity.org/dc=acegisecurity,dc=org ldap://monkeymachine.co.uk/dc=acegisecurity,dc=org");
    }

    public void testMultipleProviderUrlsWithDifferentRootsAreRejected() {
        try {
            this.idf = new DefaultInitialDirContextFactory("ldap://acegisecurity.org/dc=acegisecurity,dc=org ldap://monkeymachine.co.uk/dc=someotherplace,dc=org");
            DefaultInitialDirContextFactoryTests.fail((String)"Different root DNs should cause an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSecureLdapUrlIsSupported() {
        this.idf = new DefaultInitialDirContextFactory("ldaps://localhost/dc=acegisecurity,dc=org");
        DefaultInitialDirContextFactoryTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)this.idf.getRootDn());
    }

    public void testServiceLocationUrlIsSupported() {
        this.idf = new DefaultInitialDirContextFactory("ldap:///dc=acegisecurity,dc=org");
        DefaultInitialDirContextFactoryTests.assertEquals((String)"dc=acegisecurity,dc=org", (String)this.idf.getRootDn());
    }
}

