/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ldap;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.acegisecurity.ldap.LdapUtils;
import org.apache.directory.server.core.configuration.Configuration;
import org.apache.directory.server.core.configuration.MutablePartitionConfiguration;
import org.apache.directory.server.core.configuration.MutableStartupConfiguration;

public class LdapTestServer {
    private DirContext serverContext;
    private MutableStartupConfiguration cfg;
    static /* synthetic */ Class class$org$apache$directory$server$core$jndi$CoreContextFactory;

    public LdapTestServer() {
        this.startLdapServer();
        this.createManagerUser();
        this.initTestData();
    }

    public void createGroup(String cn, String groupContext, String ou, String[] memberDns) {
        BasicAttributes group = new BasicAttributes("cn", cn);
        BasicAttribute members = new BasicAttribute("member");
        BasicAttribute orgUnit = new BasicAttribute("ou", ou);
        for (int i = 0; i < memberDns.length; ++i) {
            members.add(memberDns[i]);
        }
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("groupOfNames");
        group.put(objectClass);
        group.put(members);
        group.put(orgUnit);
        try {
            DirContext ctx = this.serverContext.createSubcontext("cn=" + cn + "," + groupContext, (Attributes)group);
            System.out.println("Created group " + ctx.getNameInNamespace());
        }
        catch (NameAlreadyBoundException ignore) {
        }
        catch (NamingException ne) {
            System.err.println("Failed to create group.");
            ne.printStackTrace();
        }
    }

    private void createManagerUser() {
        BasicAttributes user = new BasicAttributes("cn", "manager", true);
        user.put("userPassword", "acegisecurity");
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        user.put(objectClass);
        objectClass.add("top");
        objectClass.add("person");
        objectClass.add("organizationalPerson");
        objectClass.add("inetOrgPerson");
        user.put("sn", "Manager");
        user.put("cn", "manager");
        try {
            this.serverContext.createSubcontext("cn=manager", (Attributes)user);
        }
        catch (NameAlreadyBoundException ignore) {
        }
        catch (NamingException ne) {
            System.err.println("Failed to create manager user.");
            ne.printStackTrace();
        }
    }

    public void createOu(String name) {
        BasicAttributes ou = new BasicAttributes("ou", name);
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("organizationalUnit");
        ou.put(objectClass);
        try {
            this.serverContext.createSubcontext(name, (Attributes)ou);
        }
        catch (NameAlreadyBoundException ignore) {
        }
        catch (NamingException ne) {
            System.err.println("Failed to create ou.");
            ne.printStackTrace();
        }
    }

    public void createUser(String uid, String cn, String password) {
        BasicAttributes user = new BasicAttributes("uid", uid);
        user.put("cn", cn);
        user.put("userPassword", LdapUtils.getUtf8Bytes((String)password));
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        user.put(objectClass);
        objectClass.add("top");
        objectClass.add("person");
        objectClass.add("organizationalPerson");
        objectClass.add("inetOrgPerson");
        user.put("sn", uid);
        try {
            this.serverContext.createSubcontext("uid=" + uid + ",ou=people", (Attributes)user);
        }
        catch (NameAlreadyBoundException ignore) {
        }
        catch (NamingException ne) {
            System.err.println("Failed to create  user.");
            ne.printStackTrace();
        }
    }

    public Configuration getConfiguration() {
        return this.cfg;
    }

    private void initConfiguration() throws NamingException {
        MutablePartitionConfiguration acegiDit = new MutablePartitionConfiguration();
        acegiDit.setName("acegisecurity");
        acegiDit.setSuffix("dc=acegisecurity,dc=org");
        BasicAttributes attributes = new BasicAttributes();
        BasicAttribute objectClass = new BasicAttribute("objectClass");
        objectClass.add("top");
        objectClass.add("domain");
        objectClass.add("extensibleObject");
        attributes.put(objectClass);
        acegiDit.setContextEntry((Attributes)attributes);
        HashSet<String> indexedAttrs = new HashSet<String>();
        indexedAttrs.add("objectClass");
        indexedAttrs.add("uid");
        indexedAttrs.add("cn");
        indexedAttrs.add("ou");
        indexedAttrs.add("member");
        acegiDit.setIndexedAttributes(indexedAttrs);
        HashSet<MutablePartitionConfiguration> partitions = new HashSet<MutablePartitionConfiguration>();
        partitions.add(acegiDit);
        this.cfg.setContextPartitionConfigurations(partitions);
    }

    private void initTestData() {
        this.createOu("ou=people");
        this.createOu("ou=groups");
        this.createOu("ou=subgroups,ou=groups");
        this.createUser("bob", "Bob Hamilton", "bobspassword");
        this.createUser("ben", "Ben Alex", "{SHA}nFCebWjxfaLbHHG1Qk5UU4trbvQ=");
        String[] developers = new String[]{"uid=ben,ou=people,dc=acegisecurity,dc=org", "uid=bob,ou=people,dc=acegisecurity,dc=org"};
        this.createGroup("developers", "ou=groups", "developer", developers);
        this.createGroup("managers", "ou=groups", "manager", new String[]{developers[0]});
        this.createGroup("submanagers", "ou=subgroups,ou=groups", "submanager", new String[]{developers[0]});
    }

    public static void main(String[] args) {
        LdapTestServer server = new LdapTestServer();
    }

    private void startLdapServer() {
        this.cfg = new MutableStartupConfiguration();
        String apacheWorkDir = System.getProperty("apacheDSWorkDir");
        if (apacheWorkDir == null) {
            apacheWorkDir = System.getProperty("java.io.tmpdir") + File.separator + "apacheds-work";
        }
        File workingDir = new File(apacheWorkDir);
        this.deleteDir(workingDir);
        this.cfg.setWorkingDirectory(workingDir);
        System.out.println("Ldap Server Working directory is " + workingDir.getAbsolutePath());
        Properties env = new Properties();
        env.setProperty("java.naming.provider.url", "dc=acegisecurity,dc=org");
        env.setProperty("java.naming.factory.initial", (class$org$apache$directory$server$core$jndi$CoreContextFactory == null ? (class$org$apache$directory$server$core$jndi$CoreContextFactory = LdapTestServer.class$("org.apache.directory.server.core.jndi.CoreContextFactory")) : class$org$apache$directory$server$core$jndi$CoreContextFactory).getName());
        env.setProperty("java.naming.security.authentication", "simple");
        env.setProperty("java.naming.security.principal", "uid=admin,ou=system");
        env.setProperty("java.naming.security.credentials", "secret");
        try {
            this.initConfiguration();
            env.putAll((Map<?, ?>)this.cfg.toJndiEnvironment());
            this.serverContext = new InitialDirContext(env);
        }
        catch (NamingException e) {
            System.err.println("Failed to start Apache DS");
            e.printStackTrace();
        }
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

