/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.AbstractAuthenticationToken;

public class AbstractAuthenticationTokenTests
extends TestCase {
    private GrantedAuthority[] authorities = null;
    static /* synthetic */ Class class$org$acegisecurity$providers$AbstractAuthenticationTokenTests;

    public AbstractAuthenticationTokenTests() {
    }

    public AbstractAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$AbstractAuthenticationTokenTests == null ? (class$org$acegisecurity$providers$AbstractAuthenticationTokenTests = AbstractAuthenticationTokenTests.class$("org.acegisecurity.providers.AbstractAuthenticationTokenTests")) : class$org$acegisecurity$providers$AbstractAuthenticationTokenTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
        this.authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")};
    }

    public void testAuthoritiesAreImmutable() {
        MockAuthenticationImpl token = new MockAuthenticationImpl("Test", "Password", this.authorities);
        GrantedAuthority[] gotAuthorities = token.getAuthorities();
        AbstractAuthenticationTokenTests.assertNotSame((Object)this.authorities, (Object)gotAuthorities);
        gotAuthorities[0] = new GrantedAuthorityImpl("ROLE_SUPER_USER");
        gotAuthorities = token.getAuthorities();
        AbstractAuthenticationTokenTests.assertEquals((int)2, (int)gotAuthorities.length);
        AbstractAuthenticationTokenTests.assertEquals((Object)gotAuthorities[0], (Object)this.authorities[0]);
        AbstractAuthenticationTokenTests.assertEquals((Object)gotAuthorities[1], (Object)this.authorities[1]);
        AbstractAuthenticationTokenTests.assertFalse((boolean)gotAuthorities[0].equals("ROLE_SUPER_USER"));
        AbstractAuthenticationTokenTests.assertFalse((boolean)gotAuthorities[1].equals("ROLE_SUPER_USER"));
    }

    public void testGetters() throws Exception {
        MockAuthenticationImpl token = new MockAuthenticationImpl("Test", "Password", this.authorities);
        AbstractAuthenticationTokenTests.assertEquals((Object)"Test", (Object)token.getPrincipal());
        AbstractAuthenticationTokenTests.assertEquals((Object)"Password", (Object)token.getCredentials());
        AbstractAuthenticationTokenTests.assertEquals((String)"Test", (String)token.getName());
    }

    public void testHashCode() throws Exception {
        MockAuthenticationImpl token1 = new MockAuthenticationImpl("Test", "Password", this.authorities);
        MockAuthenticationImpl token2 = new MockAuthenticationImpl("Test", "Password", this.authorities);
        MockAuthenticationImpl token3 = new MockAuthenticationImpl(null, null, new GrantedAuthority[0]);
        AbstractAuthenticationTokenTests.assertEquals((int)token1.hashCode(), (int)token2.hashCode());
        AbstractAuthenticationTokenTests.assertTrue((token1.hashCode() != token3.hashCode() ? 1 : 0) != 0);
        token2.setAuthenticated(true);
        AbstractAuthenticationTokenTests.assertTrue((token1.hashCode() != token2.hashCode() ? 1 : 0) != 0);
    }

    public void testObjectsEquals() throws Exception {
        MockAuthenticationImpl token1 = new MockAuthenticationImpl("Test", "Password", this.authorities);
        MockAuthenticationImpl token2 = new MockAuthenticationImpl("Test", "Password", this.authorities);
        AbstractAuthenticationTokenTests.assertEquals((Object)((Object)token1), (Object)((Object)token2));
        MockAuthenticationImpl token3 = new MockAuthenticationImpl("Test", "Password_Changed", this.authorities);
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals((Object)token3) ? 1 : 0) != 0);
        MockAuthenticationImpl token4 = new MockAuthenticationImpl("Test_Changed", "Password", this.authorities);
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals((Object)token4) ? 1 : 0) != 0);
        MockAuthenticationImpl token5 = new MockAuthenticationImpl("Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO_CHANGED")});
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals((Object)token5) ? 1 : 0) != 0);
        MockAuthenticationImpl token6 = new MockAuthenticationImpl("Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE")});
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals((Object)token6) ? 1 : 0) != 0);
        MockAuthenticationImpl token7 = new MockAuthenticationImpl("Test", "Password", null);
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals((Object)token7) ? 1 : 0) != 0);
        AbstractAuthenticationTokenTests.assertTrue((!token7.equals((Object)token1) ? 1 : 0) != 0);
        AbstractAuthenticationTokenTests.assertTrue((!token1.equals(new Integer(100)) ? 1 : 0) != 0);
    }

    public void testSetAuthenticated() throws Exception {
        MockAuthenticationImpl token = new MockAuthenticationImpl("Test", "Password", this.authorities);
        AbstractAuthenticationTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
        token.setAuthenticated(true);
        AbstractAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
    }

    public void testToStringWithAuthorities() {
        MockAuthenticationImpl token = new MockAuthenticationImpl("Test", "Password", this.authorities);
        AbstractAuthenticationTokenTests.assertTrue((token.toString().lastIndexOf("ROLE_TWO") != -1 ? 1 : 0) != 0);
    }

    public void testToStringWithNullAuthorities() {
        MockAuthenticationImpl token = new MockAuthenticationImpl("Test", "Password", null);
        AbstractAuthenticationTokenTests.assertTrue((token.toString().lastIndexOf("Not granted any authorities") != -1 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAuthenticationImpl
    extends AbstractAuthenticationToken {
        private Object credentials;
        private Object principal;

        public MockAuthenticationImpl(Object principal, Object credentials, GrantedAuthority[] authorities) {
            super(authorities);
            this.principal = principal;
            this.credentials = credentials;
        }

        private MockAuthenticationImpl() {
            super(null);
        }

        public Object getCredentials() {
            return this.credentials;
        }

        public Object getPrincipal() {
            return this.principal;
        }
    }
}

