/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.anonymous;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.providers.anonymous.AnonymousProcessingFilter;
import org.acegisecurity.userdetails.memory.UserAttribute;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class AnonymousProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilterTests;

    public AnonymousProcessingFilterTests() {
    }

    public AnonymousProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilterTests == null ? (class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilterTests = AnonymousProcessingFilterTests.class$("org.acegisecurity.providers.anonymous.AnonymousProcessingFilterTests")) : class$org$acegisecurity$providers$anonymous$AnonymousProcessingFilterTests));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDetectsMissingKey() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousProcessingFilter filter = new AnonymousProcessingFilter();
        filter.setUserAttribute(user);
        try {
            filter.afterPropertiesSet();
            AnonymousProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsUserAttribute() throws Exception {
        AnonymousProcessingFilter filter = new AnonymousProcessingFilter();
        filter.setKey("qwerty");
        try {
            filter.afterPropertiesSet();
            AnonymousProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AnonymousProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousProcessingFilter filter = new AnonymousProcessingFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        AnonymousProcessingFilterTests.assertTrue((boolean)filter.isRemoveAfterRequest());
        filter.afterPropertiesSet();
        AnonymousProcessingFilterTests.assertEquals((String)"qwerty", (String)filter.getKey());
        AnonymousProcessingFilterTests.assertEquals((Object)user, (Object)filter.getUserAttribute());
        filter.setRemoveAfterRequest(false);
        AnonymousProcessingFilterTests.assertFalse((boolean)filter.isRemoveAfterRequest());
    }

    public void testOperationWhenAuthenticationExistsInContextHolder() throws Exception {
        TestingAuthenticationToken originalAuth = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)originalAuth);
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousProcessingFilter filter = new AnonymousProcessingFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        AnonymousProcessingFilterTests.assertEquals((Object)originalAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOperationWhenNoAuthenticationInSecurityContextHolder() throws Exception {
        UserAttribute user = new UserAttribute();
        user.setPassword("anonymousUsername");
        user.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_ANONYMOUS"));
        AnonymousProcessingFilter filter = new AnonymousProcessingFilter();
        filter.setKey("qwerty");
        filter.setUserAttribute(user);
        filter.setRemoveAfterRequest(false);
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        AnonymousProcessingFilterTests.assertEquals((Object)"anonymousUsername", (Object)auth.getPrincipal());
        AnonymousProcessingFilterTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_ANONYMOUS"), (Object)auth.getAuthorities()[0]);
        SecurityContextHolder.getContext().setAuthentication(null);
        filter.setRemoveAfterRequest(true);
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        AnonymousProcessingFilterTests.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

