/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthenticationProvider;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthoritiesPopulator;
import org.acegisecurity.providers.cas.CasProxyDecider;
import org.acegisecurity.providers.cas.ProxyUntrustedException;
import org.acegisecurity.providers.cas.StatelessTicketCache;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.TicketValidator;
import org.acegisecurity.providers.cas.ticketvalidator.AbstractTicketValidator;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class CasAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationToken;

    public CasAuthenticationProviderTests() {
    }

    public CasAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$CasAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationProviderTests = CasAuthenticationProviderTests.class$("org.acegisecurity.providers.cas.CasAuthenticationProviderTests")) : class$org$acegisecurity$providers$cas$CasAuthenticationProviderTests));
    }

    private UserDetails makeUserDetails() {
        return new User("user", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    private UserDetails makeUserDetailsFromAuthoritiesPopulator() {
        return new User("user", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticateStateful() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider(true));
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)"ST-123");
        Authentication result = cap.authenticate((Authentication)token);
        CasAuthenticationProviderTests.assertTrue((cache.getByTicketId("ST-456") == null ? 1 : 0) != 0);
        if (!(result instanceof CasAuthenticationToken)) {
            CasAuthenticationProviderTests.fail((String)"Should have returned a CasAuthenticationToken");
        }
        CasAuthenticationToken casResult = (CasAuthenticationToken)result;
        CasAuthenticationProviderTests.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)casResult.getPrincipal());
        CasAuthenticationProviderTests.assertEquals((String)"PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt", (String)casResult.getProxyGrantingTicketIou());
        CasAuthenticationProviderTests.assertEquals((Object)"https://localhost/portal/j_acegi_cas_security_check", casResult.getProxyList().get(0));
        CasAuthenticationProviderTests.assertEquals((Object)"ST-123", (Object)casResult.getCredentials());
        CasAuthenticationProviderTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_A"), (Object)casResult.getAuthorities()[0]);
        CasAuthenticationProviderTests.assertEquals((Object)new GrantedAuthorityImpl("ROLE_B"), (Object)casResult.getAuthorities()[1]);
        CasAuthenticationProviderTests.assertEquals((int)cap.getKey().hashCode(), (int)casResult.getKeyHash());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(false));
        Authentication laterResult = cap.authenticate(result);
        CasAuthenticationProviderTests.assertEquals((Object)result, (Object)laterResult);
    }

    public void testAuthenticateStateless() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider(true));
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateless_", (Object)"ST-456");
        Authentication result = cap.authenticate((Authentication)token);
        CasAuthenticationProviderTests.assertTrue((cache.getByTicketId("ST-456") != null ? 1 : 0) != 0);
        if (!(result instanceof CasAuthenticationToken)) {
            CasAuthenticationProviderTests.fail((String)"Should have returned a CasAuthenticationToken");
        }
        CasAuthenticationProviderTests.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)result.getPrincipal());
        CasAuthenticationProviderTests.assertEquals((Object)"ST-456", (Object)result.getCredentials());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(false));
        Authentication newResult = cap.authenticate((Authentication)token);
        CasAuthenticationProviderTests.assertEquals((Object)this.makeUserDetailsFromAuthoritiesPopulator(), (Object)newResult.getPrincipal());
        CasAuthenticationProviderTests.assertEquals((Object)"ST-456", (Object)newResult.getCredentials());
    }

    public void testDetectsAMissingTicketId() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider(true));
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"_cas_stateful_", (Object)"");
        try {
            Authentication result = cap.authenticate((Authentication)token);
            CasAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"Failed to provide a CAS service ticket to validate", (String)expected.getMessage());
        }
    }

    public void testDetectsAnInvalidKey() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider(true));
        cap.setKey("qwerty");
        MockStatelessTicketCache cache = new MockStatelessTicketCache();
        cap.setStatelessTicketCache((StatelessTicketCache)cache);
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        CasAuthenticationToken token = new CasAuthenticationToken("WRONG_KEY", (Object)this.makeUserDetails(), (Object)"credentials", new GrantedAuthority[]{new GrantedAuthorityImpl("XX")}, this.makeUserDetails(), new Vector(), "IOU-xxx");
        try {
            Authentication result = cap.authenticate((Authentication)token);
            CasAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"The presented CasAuthenticationToken does not contain the expected key", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingAuthoritiesPopulator() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        try {
            cap.afterPropertiesSet();
            CasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"A casAuthoritiesPopulator must be set", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingKey() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        try {
            cap.afterPropertiesSet();
            CasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"A Key is required so CasAuthenticationProvider can identify tokens it previously authenticated", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingProxyDecider() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        try {
            cap.afterPropertiesSet();
            CasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"A casProxyDecider must be set", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingStatelessTicketCache() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setStatelessTicketCache(null);
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setKey("qwerty");
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        try {
            cap.afterPropertiesSet();
            CasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"A statelessTicketCache must be set", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingTicketValidator() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider(true));
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        try {
            cap.afterPropertiesSet();
            CasAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationProviderTests.assertEquals((String)"A ticketValidator must be set", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        CasAuthenticationProviderTests.assertTrue((cap.getCasAuthoritiesPopulator() != null ? 1 : 0) != 0);
        CasAuthenticationProviderTests.assertTrue((cap.getCasProxyDecider() != null ? 1 : 0) != 0);
        CasAuthenticationProviderTests.assertEquals((String)"qwerty", (String)cap.getKey());
        CasAuthenticationProviderTests.assertTrue((cap.getStatelessTicketCache() != null ? 1 : 0) != 0);
        CasAuthenticationProviderTests.assertTrue((cap.getTicketValidator() != null ? 1 : 0) != 0);
    }

    public void testIgnoresClassesItDoesNotSupport() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        CasAuthenticationProviderTests.assertFalse((boolean)cap.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = CasAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken));
        CasAuthenticationProviderTests.assertEquals(null, (Object)cap.authenticate((Authentication)token));
    }

    public void testIgnoresUsernamePasswordAuthenticationTokensWithoutCasIdentifiersAsPrincipal() throws Exception {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        cap.setCasAuthoritiesPopulator((CasAuthoritiesPopulator)new MockAuthoritiesPopulator());
        cap.setCasProxyDecider((CasProxyDecider)new MockProxyDecider());
        cap.setKey("qwerty");
        cap.setStatelessTicketCache((StatelessTicketCache)new MockStatelessTicketCache());
        cap.setTicketValidator((TicketValidator)new MockTicketValidator(true));
        cap.afterPropertiesSet();
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"some_normal_user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        CasAuthenticationProviderTests.assertEquals(null, (Object)cap.authenticate((Authentication)token));
    }

    public void testSupports() {
        CasAuthenticationProvider cap = new CasAuthenticationProvider();
        CasAuthenticationProviderTests.assertTrue((boolean)cap.supports(class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = CasAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken));
        CasAuthenticationProviderTests.assertTrue((boolean)cap.supports(class$org$acegisecurity$providers$cas$CasAuthenticationToken == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationToken = CasAuthenticationProviderTests.class$("org.acegisecurity.providers.cas.CasAuthenticationToken")) : class$org$acegisecurity$providers$cas$CasAuthenticationToken));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockTicketValidator
    extends AbstractTicketValidator {
        private boolean returnTicket;

        public MockTicketValidator(boolean returnTicket) {
            this.returnTicket = returnTicket;
        }

        private MockTicketValidator() {
        }

        public TicketResponse confirmTicketValid(String serviceTicket) throws AuthenticationException {
            if (this.returnTicket) {
                Vector<String> list = new Vector<String>();
                list.add("https://localhost/portal/j_acegi_cas_security_check");
                return new TicketResponse("marissa", list, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            }
            throw new BadCredentialsException("As requested from mock");
        }
    }

    private class MockStatelessTicketCache
    implements StatelessTicketCache {
        private Map cache = new HashMap();

        private MockStatelessTicketCache() {
        }

        public CasAuthenticationToken getByTicketId(String serviceTicket) {
            return (CasAuthenticationToken)this.cache.get(serviceTicket);
        }

        public void putTicketInCache(CasAuthenticationToken token) {
            this.cache.put(token.getCredentials().toString(), token);
        }

        public void removeTicketFromCache(CasAuthenticationToken token) {
            throw new UnsupportedOperationException("mock method not implemented");
        }

        public void removeTicketFromCache(String serviceTicket) {
            throw new UnsupportedOperationException("mock method not implemented");
        }
    }

    private class MockProxyDecider
    implements CasProxyDecider {
        private boolean acceptProxy;

        public MockProxyDecider(boolean acceptProxy) {
            this.acceptProxy = acceptProxy;
        }

        private MockProxyDecider() {
        }

        public void confirmProxyListTrusted(List proxyList) throws ProxyUntrustedException {
            if (this.acceptProxy) {
                return;
            }
            throw new ProxyUntrustedException("As requested from mock");
        }
    }

    private class MockAuthoritiesPopulator
    implements CasAuthoritiesPopulator {
        private MockAuthoritiesPopulator() {
        }

        public UserDetails getUserDetails(String casUserId) throws AuthenticationException {
            return CasAuthenticationProviderTests.this.makeUserDetailsFromAuthoritiesPopulator();
        }
    }
}

