/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class CasAuthenticationTokenTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationTokenTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$CasAuthenticationToken;

    public CasAuthenticationTokenTests() {
    }

    public CasAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$CasAuthenticationTokenTests == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationTokenTests = CasAuthenticationTokenTests.class$("org.acegisecurity.providers.cas.CasAuthenticationTokenTests")) : class$org$acegisecurity$providers$cas$CasAuthenticationTokenTests));
    }

    private UserDetails makeUserDetails() {
        return this.makeUserDetails("user");
    }

    private UserDetails makeUserDetails(String name) {
        return new User(name, "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructorRejectsNulls() {
        try {
            new CasAuthenticationToken(null, (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", null, (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), null, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", null, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), null, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, null, new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), null);
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
        try {
            new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), null, new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            CasAuthenticationTokenTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testEqualsWhenEqual() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        Vector<String> proxyList2 = new Vector<String>();
        proxyList2.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList2, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertEquals((Object)token1, (Object)token2);
    }

    public void testGetters() {
        Vector<String> proxyList = new Vector<String>();
        proxyList.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertEquals((int)"key".hashCode(), (int)token.getKeyHash());
        CasAuthenticationTokenTests.assertEquals((Object)this.makeUserDetails(), (Object)token.getPrincipal());
        CasAuthenticationTokenTests.assertEquals((Object)"Password", (Object)token.getCredentials());
        CasAuthenticationTokenTests.assertEquals((String)"ROLE_ONE", (String)token.getAuthorities()[0].getAuthority());
        CasAuthenticationTokenTests.assertEquals((String)"ROLE_TWO", (String)token.getAuthorities()[1].getAuthority());
        CasAuthenticationTokenTests.assertEquals((String)"PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt", (String)token.getProxyGrantingTicketIou());
        CasAuthenticationTokenTests.assertEquals(proxyList, (Object)token.getProxyList());
        CasAuthenticationTokenTests.assertEquals((String)this.makeUserDetails().getUsername(), (String)token.getUserDetails().getUsername());
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$providers$cas$CasAuthenticationToken == null ? (class$org$acegisecurity$providers$cas$CasAuthenticationToken = CasAuthenticationTokenTests.class$("org.acegisecurity.providers.cas.CasAuthenticationToken")) : class$org$acegisecurity$providers$cas$CasAuthenticationToken;
        try {
            clazz.getDeclaredConstructor(null);
            CasAuthenticationTokenTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            CasAuthenticationTokenTests.assertTrue((boolean)true);
        }
    }

    public void testNotEqualsDueToAbstractParentEqualsCheck() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        Vector<String> proxyList2 = new Vector<String>();
        proxyList2.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails("OTHER_NAME"), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList2, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToDifferentAuthenticationClass() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        UsernamePasswordAuthenticationToken token2 = new UsernamePasswordAuthenticationToken((Object)"Test", (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToKey() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        Vector<String> proxyList2 = new Vector<String>();
        proxyList2.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token2 = new CasAuthenticationToken("DIFFERENT_KEY", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList2, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToProxyGrantingTicket() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        Vector<String> proxyList2 = new Vector<String>();
        proxyList2.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList2, "PGTIOU-SOME_OTHER_VALUE");
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testNotEqualsDueToProxyList() {
        Vector<String> proxyList1 = new Vector<String>();
        proxyList1.add("https://localhost/newPortal/j_acegi_cas_security_check");
        CasAuthenticationToken token1 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList1, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        Vector<String> proxyList2 = new Vector<String>();
        proxyList2.add("https://localhost/SOME_OTHER_PORTAL/j_acegi_cas_security_check");
        CasAuthenticationToken token2 = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), proxyList2, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertTrue((!token1.equals((Object)token2) ? 1 : 0) != 0);
    }

    public void testSetAuthenticated() {
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        CasAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        CasAuthenticationTokenTests.assertTrue((!token.isAuthenticated() ? 1 : 0) != 0);
    }

    public void testToString() {
        CasAuthenticationToken token = new CasAuthenticationToken("key", (Object)this.makeUserDetails(), (Object)"Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, this.makeUserDetails(), new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        String result = token.toString();
        CasAuthenticationTokenTests.assertTrue((result.lastIndexOf("Proxy List:") != -1 ? 1 : 0) != 0);
        CasAuthenticationTokenTests.assertTrue((result.lastIndexOf("Proxy-Granting Ticket IOU:") != -1 ? 1 : 0) != 0);
        CasAuthenticationTokenTests.assertTrue((result.lastIndexOf("Credentials (Service/Proxy Ticket):") != -1 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

