/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.providers.cas.TicketResponse;

public class TicketResponseTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$TicketResponseTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$TicketResponse;

    public TicketResponseTests() {
    }

    public TicketResponseTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$TicketResponseTests == null ? (class$org$acegisecurity$providers$cas$TicketResponseTests = TicketResponseTests.class$("org.acegisecurity.providers.cas.TicketResponseTests")) : class$org$acegisecurity$providers$cas$TicketResponseTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConstructorAcceptsNullProxyGrantingTicketIOU() {
        TicketResponse ticket = new TicketResponse("marissa", new Vector(), null);
        TicketResponseTests.assertEquals((String)"", (String)ticket.getProxyGrantingTicketIou());
    }

    public void testConstructorAcceptsNullProxyList() {
        TicketResponse ticket = new TicketResponse("marissa", null, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        TicketResponseTests.assertEquals(new Vector(), (Object)ticket.getProxyList());
    }

    public void testConstructorRejectsNullUser() {
        try {
            new TicketResponse(null, new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            TicketResponseTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            TicketResponseTests.assertTrue((boolean)true);
        }
    }

    public void testGetters() {
        Vector<String> proxyList = new Vector<String>();
        proxyList.add("https://localhost/newPortal/j_acegi_cas_security_check");
        TicketResponse ticket = new TicketResponse("marissa", proxyList, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        TicketResponseTests.assertEquals((String)"marissa", (String)ticket.getUser());
        TicketResponseTests.assertEquals(proxyList, (Object)ticket.getProxyList());
        TicketResponseTests.assertEquals((String)"PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt", (String)ticket.getProxyGrantingTicketIou());
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$providers$cas$TicketResponse == null ? (class$org$acegisecurity$providers$cas$TicketResponse = TicketResponseTests.class$("org.acegisecurity.providers.cas.TicketResponse")) : class$org$acegisecurity$providers$cas$TicketResponse;
        try {
            clazz.getDeclaredConstructor(null);
            TicketResponseTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            TicketResponseTests.assertTrue((boolean)true);
        }
    }

    public void testToString() {
        TicketResponse ticket = new TicketResponse("marissa", null, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
        String result = ticket.toString();
        TicketResponseTests.assertTrue((result.lastIndexOf("Proxy List:") != -1 ? 1 : 0) != 0);
        TicketResponseTests.assertTrue((result.lastIndexOf("Proxy-Granting Ticket IOU:") != -1 ? 1 : 0) != 0);
        TicketResponseTests.assertTrue((result.lastIndexOf("User:") != -1 ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

