/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.cache;

import java.util.Vector;
import junit.framework.TestCase;
import net.sf.ehcache.Ehcache;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.providers.cas.CasAuthenticationToken;
import org.acegisecurity.providers.cas.cache.EhCacheBasedTicketCache;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.springframework.context.ConfigurableApplicationContext;

public class EhCacheBasedTicketCacheTests
extends TestCase {
    public EhCacheBasedTicketCacheTests() {
    }

    public EhCacheBasedTicketCacheTests(String arg0) {
        super(arg0);
    }

    private Ehcache getCache() {
        ConfigurableApplicationContext ctx = MockApplicationContext.getContext();
        return (Ehcache)ctx.getBean("eHCacheBackend");
    }

    private CasAuthenticationToken getToken() {
        Vector<String> proxyList = new Vector<String>();
        proxyList.add("https://localhost/newPortal/j_acegi_cas_security_check");
        User user = new User("marissa", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        return new CasAuthenticationToken("key", (Object)user, (Object)"ST-0-ER94xMJmn6pha35CQRoZ", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")}, (UserDetails)user, proxyList, "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCacheOperation() throws Exception {
        EhCacheBasedTicketCache cache = new EhCacheBasedTicketCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putTicketInCache(this.getToken());
        EhCacheBasedTicketCacheTests.assertEquals((Object)this.getToken(), (Object)cache.getByTicketId("ST-0-ER94xMJmn6pha35CQRoZ"));
        cache.removeTicketFromCache(this.getToken());
        EhCacheBasedTicketCacheTests.assertNull((Object)cache.getByTicketId("ST-0-ER94xMJmn6pha35CQRoZ"));
        EhCacheBasedTicketCacheTests.assertNull((Object)cache.getByTicketId(null));
        EhCacheBasedTicketCacheTests.assertNull((Object)cache.getByTicketId("UNKNOWN_SERVICE_TICKET"));
    }

    public void testStartupDetectsMissingCache() throws Exception {
        EhCacheBasedTicketCache cache = new EhCacheBasedTicketCache();
        try {
            cache.afterPropertiesSet();
            EhCacheBasedTicketCacheTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            EhCacheBasedTicketCacheTests.assertTrue((boolean)true);
        }
        Ehcache myCache = this.getCache();
        cache.setCache(myCache);
        EhCacheBasedTicketCacheTests.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

