/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.proxy;

import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.providers.cas.ProxyUntrustedException;
import org.acegisecurity.providers.cas.proxy.NamedCasProxyDecider;

public class NamedCasProxyDeciderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$proxy$NamedCasProxyDeciderTests;

    public NamedCasProxyDeciderTests() {
    }

    public NamedCasProxyDeciderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$proxy$NamedCasProxyDeciderTests == null ? (class$org$acegisecurity$providers$cas$proxy$NamedCasProxyDeciderTests = NamedCasProxyDeciderTests.class$("org.acegisecurity.providers.cas.proxy.NamedCasProxyDeciderTests")) : class$org$acegisecurity$providers$cas$proxy$NamedCasProxyDeciderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAcceptsIfNearestProxyIsAuthorized() throws Exception {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        Vector<String> proxyList = new Vector<String>();
        proxyList.add("https://localhost/newPortal/j_acegi_cas_security_check");
        Vector<String> validProxies = new Vector<String>();
        validProxies.add("https://localhost/portal/j_acegi_cas_security_check");
        validProxies.add("https://localhost/newPortal/j_acegi_cas_security_check");
        proxyDecider.setValidProxies(validProxies);
        proxyDecider.afterPropertiesSet();
        proxyDecider.confirmProxyListTrusted(proxyList);
        NamedCasProxyDeciderTests.assertTrue((boolean)true);
    }

    public void testAcceptsIfNoProxiesInTicket() {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        Vector proxyList = new Vector();
        proxyDecider.confirmProxyListTrusted(proxyList);
        NamedCasProxyDeciderTests.assertTrue((boolean)true);
    }

    public void testDetectsMissingValidProxiesList() throws Exception {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        try {
            proxyDecider.afterPropertiesSet();
            NamedCasProxyDeciderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedCasProxyDeciderTests.assertEquals((String)"A validProxies list must be set", (String)expected.getMessage());
        }
    }

    public void testDoesNotAcceptNull() {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        try {
            proxyDecider.confirmProxyListTrusted(null);
            NamedCasProxyDeciderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            NamedCasProxyDeciderTests.assertEquals((String)"proxyList cannot be null", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        Vector<String> validProxies = new Vector<String>();
        validProxies.add("https://localhost/portal/j_acegi_cas_security_check");
        validProxies.add("https://localhost/newPortal/j_acegi_cas_security_check");
        proxyDecider.setValidProxies(validProxies);
        NamedCasProxyDeciderTests.assertEquals(validProxies, (Object)proxyDecider.getValidProxies());
    }

    public void testRejectsIfNearestProxyIsNotAuthorized() throws Exception {
        NamedCasProxyDecider proxyDecider = new NamedCasProxyDecider();
        Vector<String> proxyList = new Vector<String>();
        proxyList.add("https://localhost/untrustedWebApp/j_acegi_cas_security_check");
        Vector<String> validProxies = new Vector<String>();
        validProxies.add("https://localhost/portal/j_acegi_cas_security_check");
        validProxies.add("https://localhost/newPortal/j_acegi_cas_security_check");
        proxyDecider.setValidProxies(validProxies);
        proxyDecider.afterPropertiesSet();
        try {
            proxyDecider.confirmProxyListTrusted(proxyList);
            NamedCasProxyDeciderTests.fail((String)"Should have thrown ProxyUntrustedException");
        }
        catch (ProxyUntrustedException expected) {
            NamedCasProxyDeciderTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

