/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.cas.ticketvalidator;

import edu.yale.its.tp.cas.client.ProxyTicketValidator;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.providers.cas.TicketResponse;
import org.acegisecurity.providers.cas.ticketvalidator.CasProxyTicketValidator;
import org.acegisecurity.ui.cas.ServiceProperties;

public class CasProxyTicketValidatorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidatorTests;

    public CasProxyTicketValidatorTests() {
    }

    public CasProxyTicketValidatorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidatorTests == null ? (class$org$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidatorTests = CasProxyTicketValidatorTests.class$("org.acegisecurity.providers.cas.ticketvalidator.CasProxyTicketValidatorTests")) : class$org$acegisecurity$providers$cas$ticketvalidator$CasProxyTicketValidatorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGetters() {
        CasProxyTicketValidator tv = new CasProxyTicketValidator();
        tv.setProxyCallbackUrl("http://my.com/webapp/casProxy/someValidator");
        CasProxyTicketValidatorTests.assertEquals((String)"http://my.com/webapp/casProxy/someValidator", (String)tv.getProxyCallbackUrl());
    }

    public void testNormalOperation() {
        ServiceProperties sp = new ServiceProperties();
        sp.setSendRenew(true);
        sp.setService("https://my.com/webapp//j_acegi_cas_security_check");
        MockCasProxyTicketValidator tv = new MockCasProxyTicketValidator(true, false);
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        tv.setServiceProperties(sp);
        tv.setProxyCallbackUrl("http://my.com/webapp/casProxy/someValidator");
        TicketResponse response = tv.confirmTicketValid("ST-0-ER94xMJmn6pha35CQRoZ");
        CasProxyTicketValidatorTests.assertEquals((String)"user", (String)response.getUser());
    }

    public void testProxyTicketValidatorInternalExceptionsGracefullyHandled() {
        MockCasProxyTicketValidator tv = new MockCasProxyTicketValidator(false, true);
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        tv.setServiceProperties(new ServiceProperties());
        tv.setProxyCallbackUrl("http://my.com/webapp/casProxy/someValidator");
        try {
            tv.confirmTicketValid("ST-0-ER94xMJmn6pha35CQRoZ");
            CasProxyTicketValidatorTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            CasProxyTicketValidatorTests.assertTrue((boolean)true);
        }
    }

    public void testValidationFailsOkAndOperationWithoutAProxyCallbackUrl() {
        MockCasProxyTicketValidator tv = new MockCasProxyTicketValidator(false, false);
        tv.setCasValidate("https://company.com/cas/proxyvalidate");
        tv.setServiceProperties(new ServiceProperties());
        try {
            tv.confirmTicketValid("ST-0-ER94xMJmn6pha35CQRoZ");
            CasProxyTicketValidatorTests.fail((String)"Should have thrown BadCredentialsExpected");
        }
        catch (BadCredentialsException expected) {
            CasProxyTicketValidatorTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockCasProxyTicketValidator
    extends CasProxyTicketValidator {
        private boolean returnTicket;
        private boolean throwAuthenticationServiceException;

        public MockCasProxyTicketValidator(boolean returnTicket, boolean throwAuthenticationServiceException) {
            this.returnTicket = returnTicket;
            this.throwAuthenticationServiceException = throwAuthenticationServiceException;
        }

        private MockCasProxyTicketValidator() {
        }

        protected TicketResponse validateNow(ProxyTicketValidator pv) throws AuthenticationServiceException, BadCredentialsException {
            if (this.returnTicket) {
                return new TicketResponse("user", new Vector(), "PGTIOU-0-R0zlgrl4pdAQwBvJWO3vnNpevwqStbSGcq3vKB2SqSFFRnjPHt");
            }
            if (this.throwAuthenticationServiceException) {
                throw new AuthenticationServiceException("As requested by mock");
            }
            throw new BadCredentialsException("As requested by mock");
        }
    }
}

