/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.dao;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.LockedException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.DaoAuthenticationProvider;
import org.acegisecurity.providers.dao.SaltSource;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.EhCacheBasedUserCache;
import org.acegisecurity.providers.dao.salt.SystemWideSaltSource;
import org.acegisecurity.providers.encoding.PasswordEncoder;
import org.acegisecurity.providers.encoding.ShaPasswordEncoder;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class DaoAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$DaoAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$User;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$acegisecurity$providers$encoding$ShaPasswordEncoder;
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$salt$SystemWideSaltSource;
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache;
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$cache$NullUserCache;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$dao$DaoAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$dao$DaoAuthenticationProviderTests = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.DaoAuthenticationProviderTests")) : class$org$acegisecurity$providers$dao$DaoAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticateFailsForIncorrectPasswordCase() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"KOala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testReceivedBadCredentialsWhenCredentialsNotProvided() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        UsernamePasswordAuthenticationToken authenticationToken = new UsernamePasswordAuthenticationToken((Object)"marissa", null);
        try {
            provider.authenticate((Authentication)authenticationToken);
            DaoAuthenticationProviderTests.fail((String)"Expected BadCredenialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfAccountExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterAccountExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AccountExpiredException");
        }
        catch (AccountExpiredException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfAccountLocked() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterAccountLocked());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown LockedException");
        }
        catch (LockedException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfCredentialsExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeterCredentialsExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown CredentialsExpiredException");
        }
        catch (CredentialsExpiredException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
        token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"wrong_password");
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfUserDisabled() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserPeter());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown DisabledException");
        }
        catch (DisabledException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWhenAuthenticationDaoHasBackendFailure() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoSimulateBackendError());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithEmptyUsername() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(null, (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidPassword() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"INVALID_PASSWORD");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionFalse() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setHideUserNotFoundExceptions(false);
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionsWithDefaultOfTrue() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.isHideUserNotFoundExceptions());
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithMixedCaseUsernameIfDefaultChanged() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"MaRiSSA", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticates() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        token.setDetails((Object)"192.168.0.1");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$userdetails$User == null ? (class$org$acegisecurity$userdetails$User = DaoAuthenticationProviderTests.class$("org.acegisecurity.userdetails.User")) : class$org$acegisecurity$userdetails$User), castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((Object)"192.168.0.1", (Object)castResult.getDetails());
    }

    public void testAuthenticatesASecondTime() {
        Authentication result2;
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        if (!((result2 = provider.authenticate(result)) instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        DaoAuthenticationProviderTests.assertEquals((Object)result.getCredentials(), (Object)result2.getCredentials());
    }

    public void testAuthenticatesWhenASaltIsUsed() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SystemWideSaltSource salt = new SystemWideSaltSource();
        salt.setSystemWideSalt("SYSTEM_SALT_VALUE");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissaWithSalt());
        provider.setSaltSource((SaltSource)salt);
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$userdetails$User == null ? (class$org$acegisecurity$userdetails$User = DaoAuthenticationProviderTests.class$("org.acegisecurity.userdetails.User")) : class$org$acegisecurity$userdetails$User), castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        DaoAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
    }

    public void testAuthenticatesWithForcePrincipalAsString() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        provider.setForcePrincipalAsString(true);
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            DaoAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        DaoAuthenticationProviderTests.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = DaoAuthenticationProviderTests.class$("java.lang.String")) : class$java$lang$String), castResult.getPrincipal().getClass());
        DaoAuthenticationProviderTests.assertEquals((Object)"marissa", (Object)castResult.getPrincipal());
    }

    public void testDetectsNullBeingReturnedFromAuthenticationDao() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoReturnsNull());
        try {
            provider.authenticate((Authentication)token);
            DaoAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            DaoAuthenticationProviderTests.assertEquals((String)"UserDetailsService returned null, which is an interface contract violation", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setPasswordEncoder((PasswordEncoder)new ShaPasswordEncoder());
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$encoding$ShaPasswordEncoder == null ? (class$org$acegisecurity$providers$encoding$ShaPasswordEncoder = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.encoding.ShaPasswordEncoder")) : class$org$acegisecurity$providers$encoding$ShaPasswordEncoder), provider.getPasswordEncoder().getClass());
        provider.setSaltSource((SaltSource)new SystemWideSaltSource());
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$dao$salt$SystemWideSaltSource == null ? (class$org$acegisecurity$providers$dao$salt$SystemWideSaltSource = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.salt.SystemWideSaltSource")) : class$org$acegisecurity$providers$dao$salt$SystemWideSaltSource), provider.getSaltSource().getClass());
        provider.setUserCache((UserCache)new EhCacheBasedUserCache());
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache == null ? (class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.cache.EhCacheBasedUserCache")) : class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache), provider.getUserCache().getClass());
        DaoAuthenticationProviderTests.assertFalse((boolean)provider.isForcePrincipalAsString());
        provider.setForcePrincipalAsString(true);
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.isForcePrincipalAsString());
    }

    public void testGoesBackToAuthenticationDaoToObtainLatestPasswordIfCachedPasswordSeemsIncorrect() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        MockAuthenticationDaoUserMarissa authenticationDao = new MockAuthenticationDaoUserMarissa();
        MockUserCache cache = new MockUserCache();
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)authenticationDao);
        provider.setUserCache((UserCache)cache);
        provider.authenticate((Authentication)token);
        DaoAuthenticationProviderTests.assertEquals((String)"koala", (String)cache.getUserFromCache("marissa").getPassword());
        authenticationDao.setPassword("easternLongNeckTurtle");
        token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"easternLongNeckTurtle");
        provider.authenticate((Authentication)token);
        DaoAuthenticationProviderTests.assertEquals((String)"easternLongNeckTurtle", (String)cache.getUserFromCache("marissa").getPassword());
    }

    public void testStartupFailsIfNoAuthenticationDao() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            DaoAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfNoUserCacheSet() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserMarissa());
        DaoAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$dao$cache$NullUserCache == null ? (class$org$acegisecurity$providers$dao$cache$NullUserCache = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.cache.NullUserCache")) : class$org$acegisecurity$providers$dao$cache$NullUserCache), provider.getUserCache().getClass());
        provider.setUserCache(null);
        try {
            provider.afterPropertiesSet();
            DaoAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            DaoAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccess() throws Exception {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        MockAuthenticationDaoUserMarissa userDetailsService = new MockAuthenticationDaoUserMarissa();
        provider.setUserDetailsService((UserDetailsService)userDetailsService);
        provider.setUserCache((UserCache)new MockUserCache());
        DaoAuthenticationProviderTests.assertEquals((Object)userDetailsService, (Object)provider.getUserDetailsService());
        provider.afterPropertiesSet();
        DaoAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSupports() {
        DaoAuthenticationProvider provider = new DaoAuthenticationProvider();
        DaoAuthenticationProviderTests.assertTrue((boolean)provider.supports(class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken));
        DaoAuthenticationProviderTests.assertTrue((!provider.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = DaoAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockUserCache
    implements UserCache {
        private Map cache = new HashMap();

        private MockUserCache() {
        }

        public UserDetails getUserFromCache(String username) {
            return (User)this.cache.get(username);
        }

        public void putUserInCache(UserDetails user) {
            this.cache.put(user.getUsername(), user);
        }

        public void removeUserFromCache(String username) {
        }
    }

    private class MockAuthenticationDaoUserPeterCredentialsExpired
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterCredentialsExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeterAccountLocked
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterAccountLocked() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, true, false, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeterAccountExpired
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeterAccountExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserPeter
    implements UserDetailsService {
        private MockAuthenticationDaoUserPeter() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserMarissaWithSalt
    implements UserDetailsService {
        private MockAuthenticationDaoUserMarissaWithSalt() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("marissa".equals(username)) {
                return new User("marissa", "koala{SYSTEM_SALT_VALUE}", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockAuthenticationDaoUserMarissa
    implements UserDetailsService {
        private String password = "koala";

        private MockAuthenticationDaoUserMarissa() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("marissa".equals(username)) {
                return new User("marissa", this.password, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    private class MockAuthenticationDaoSimulateBackendError
    implements UserDetailsService {
        private MockAuthenticationDaoSimulateBackendError() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            throw new DataRetrievalFailureException("This mock simulator is designed to fail");
        }
    }

    private class MockAuthenticationDaoReturnsNull
    implements UserDetailsService {
        private MockAuthenticationDaoReturnsNull() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            return null;
        }
    }
}

