/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.jaas;

import java.util.HashMap;
import java.util.HashSet;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.jaas.SecurityContextLoginModule;

public class SecurityContextLoginModuleTests
extends TestCase {
    private SecurityContextLoginModule module = null;
    private Subject subject = new Subject(false, new HashSet(), new HashSet(), new HashSet());
    private UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"principal", (Object)"credentials");

    protected void setUp() throws Exception {
        this.module = new SecurityContextLoginModule();
        this.module.initialize(this.subject, null, null, null);
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
        this.module = null;
    }

    public void testAbort() throws Exception {
        SecurityContextLoginModuleTests.assertFalse((String)"Should return false, no auth is set", (boolean)this.module.abort());
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.auth);
        this.module.login();
        this.module.commit();
        SecurityContextLoginModuleTests.assertTrue((boolean)this.module.abort());
    }

    public void testLoginException() throws Exception {
        try {
            this.module.login();
            SecurityContextLoginModuleTests.fail((String)"LoginException expected, there is no Authentication in the SecurityContext");
        }
        catch (LoginException loginException) {
            // empty catch block
        }
    }

    public void testLoginSuccess() throws Exception {
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.auth);
        SecurityContextLoginModuleTests.assertTrue((String)"Login should succeed, there is an authentication set", (boolean)this.module.login());
        SecurityContextLoginModuleTests.assertTrue((String)"The authentication is not null, this should return true", (boolean)this.module.commit());
        SecurityContextLoginModuleTests.assertTrue((String)"Principals should contain the authentication", (boolean)this.subject.getPrincipals().contains(this.auth));
    }

    public void testLogout() throws Exception {
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.auth);
        this.module.login();
        SecurityContextLoginModuleTests.assertTrue((String)"Should return true as it succeeds", (boolean)this.module.logout());
        SecurityContextLoginModuleTests.assertEquals((String)"Authentication should be null", null, (Object)this.module.getAuthentication());
        SecurityContextLoginModuleTests.assertFalse((String)"Principals should not contain the authentication after logout", (boolean)this.subject.getPrincipals().contains(this.auth));
    }

    public void testNullAuthenticationInSecurityContext() throws Exception {
        try {
            SecurityContextHolder.getContext().setAuthentication(null);
            this.module.login();
            SecurityContextLoginModuleTests.fail((String)"LoginException expected, the authentication is null in the SecurityContext");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testNullAuthenticationInSecurityContextIgnored() throws Exception {
        this.module = new SecurityContextLoginModule();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ignoreMissingAuthentication", "true");
        this.module.initialize(this.subject, null, null, options);
        SecurityContextHolder.getContext().setAuthentication(null);
        SecurityContextLoginModuleTests.assertFalse((String)"Should return false and ask to be ignored", (boolean)this.module.login());
    }

    public void testNullLogout() throws Exception {
        SecurityContextLoginModuleTests.assertFalse((boolean)this.module.logout());
    }
}

