/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap;

import java.util.ArrayList;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import junit.framework.TestCase;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.ldap.LdapAuthenticationProvider;
import org.acegisecurity.providers.ldap.LdapAuthenticator;
import org.acegisecurity.providers.ldap.LdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;

public class LdapAuthenticationProviderTests
extends TestCase {
    public LdapAuthenticationProviderTests(String string) {
        super(string);
    }

    public LdapAuthenticationProviderTests() {
    }

    public void testDifferentCacheValueCausesException() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
        UserDetails user = ldapProvider.retrieveUser("bob", authRequest);
        authRequest = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"wrongpassword");
        try {
            ldapProvider.additionalAuthenticationChecks(user, authRequest);
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException should have failed with wrong password");
        }
        catch (BadCredentialsException expected) {
            // empty catch block
        }
    }

    public void testEmptyOrNullUserNameThrowsException() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        try {
            ldapProvider.retrieveUser("", new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword"));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for empty username");
        }
        catch (BadCredentialsException expected) {
            // empty catch block
        }
        try {
            ldapProvider.retrieveUser(null, new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword"));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for null username");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testEmptyPasswordIsRejected() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator());
        try {
            ldapProvider.retrieveUser("jen", new UsernamePasswordAuthenticationToken((Object)"jen", (Object)""));
            LdapAuthenticationProviderTests.fail((String)"Expected BadCredentialsException for empty password");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testNormalUsage() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator(), (LdapAuthoritiesPopulator)new MockAuthoritiesPopulator());
        LdapAuthenticationProviderTests.assertNotNull((Object)ldapProvider.getAuthoritiesPopulator());
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
        UserDetails user = ldapProvider.retrieveUser("bob", authRequest);
        LdapAuthenticationProviderTests.assertEquals((int)2, (int)user.getAuthorities().length);
        LdapAuthenticationProviderTests.assertEquals((String)"bobspassword", (String)user.getPassword());
        LdapAuthenticationProviderTests.assertEquals((String)"bob", (String)user.getUsername());
        ArrayList<String> authorities = new ArrayList<String>();
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        LdapAuthenticationProviderTests.assertTrue((boolean)authorities.contains("ROLE_FROM_ENTRY"));
        LdapAuthenticationProviderTests.assertTrue((boolean)authorities.contains("ROLE_FROM_POPULATOR"));
        ldapProvider.additionalAuthenticationChecks(user, authRequest);
    }

    public void testUseWithNullAuthoritiesPopulatorReturnsCorrectRole() {
        LdapAuthenticationProvider ldapProvider = new LdapAuthenticationProvider((LdapAuthenticator)new MockAuthenticator());
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"bob", (Object)"bobspassword");
        UserDetails user = ldapProvider.retrieveUser("bob", authRequest);
        LdapAuthenticationProviderTests.assertEquals((int)1, (int)user.getAuthorities().length);
        LdapAuthenticationProviderTests.assertEquals((String)"ROLE_FROM_ENTRY", (String)user.getAuthorities()[0].getAuthority());
    }

    class MockAuthoritiesPopulator
    implements LdapAuthoritiesPopulator {
        MockAuthoritiesPopulator() {
        }

        public GrantedAuthority[] getGrantedAuthorities(LdapUserDetails userDetailsll) {
            return new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FROM_POPULATOR")};
        }
    }

    class MockAuthenticator
    implements LdapAuthenticator {
        Attributes userAttributes = new BasicAttributes("cn", "bob");

        MockAuthenticator() {
        }

        public LdapUserDetails authenticate(String username, String password) {
            LdapUserDetailsImpl.Essence userEssence = new LdapUserDetailsImpl.Essence();
            userEssence.setPassword("{SHA}anencodedpassword");
            userEssence.setAttributes(this.userAttributes);
            if (username.equals("bob") && password.equals("bobspassword")) {
                userEssence.setDn("cn=bob,ou=people,dc=acegisecurity,dc=org");
                userEssence.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_FROM_ENTRY"));
                return userEssence.createUserDetails();
            }
            if (username.equals("jen") && password.equals("")) {
                userEssence.setDn("cn=jen,ou=people,dc=acegisecurity,dc=org");
                userEssence.addAuthority((GrantedAuthority)new GrantedAuthorityImpl("ROLE_FROM_ENTRY"));
                return userEssence.createUserDetails();
            }
            throw new BadCredentialsException("Authentication failed.");
        }
    }
}

