/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import junit.framework.TestCase;
import org.acegisecurity.providers.ldap.authenticator.LdapShaPasswordEncoder;

public class LdapShaPasswordEncoderTests
extends TestCase {
    LdapShaPasswordEncoder sha;

    protected void setUp() throws Exception {
        super.setUp();
        this.sha = new LdapShaPasswordEncoder();
    }

    public void testInvalidPasswordFails() {
        LdapShaPasswordEncoderTests.assertFalse((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "wrongpassword", null));
    }

    public void testInvalidSaltedPasswordFails() {
        LdapShaPasswordEncoderTests.assertFalse((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "wrongpassword", null));
        LdapShaPasswordEncoderTests.assertFalse((boolean)this.sha.isPasswordValid("{SSHA}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "wrongpassword", null));
    }

    public void testNonByteArraySaltThrowsException() {
        try {
            this.sha.encodePassword("password", (Object)"AStringNotAByteArray");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testValidPasswordSucceeds() {
        this.sha.setForceLowerCasePrefix(false);
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        this.sha.setForceLowerCasePrefix(true);
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", "boabspasswurd", null));
    }

    public void testValidSaltedPasswordSucceeds() {
        this.sha.setForceLowerCasePrefix(false);
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{ssha}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "boabspasswurd", null));
        this.sha.setForceLowerCasePrefix(true);
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{SSHA}25ro4PKC8jhQZ26jVsozhX/xaP0suHgX", "boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.isPasswordValid("{ssha}PQy2j+6n5ytA+YlAKkM8Fh4p6u2JxfVd", "boabspasswurd", null));
    }

    public void testCorrectPrefixCaseIsUsed() {
        this.sha.setForceLowerCasePrefix(false);
        LdapShaPasswordEncoderTests.assertEquals((String)"{SHA}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", (String)this.sha.encodePassword("boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.encodePassword("somepassword", (Object)"salt".getBytes()).startsWith("{SSHA}"));
        this.sha.setForceLowerCasePrefix(true);
        LdapShaPasswordEncoderTests.assertEquals((String)"{sha}ddSFGmjXYPbZC+NXR2kCzBRjqiE=", (String)this.sha.encodePassword("boabspasswurd", null));
        LdapShaPasswordEncoderTests.assertTrue((boolean)this.sha.encodePassword("somepassword", (Object)"salt".getBytes()).startsWith("{ssha}"));
    }
}

