/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.populator;

import java.util.HashSet;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.ldap.AbstractLdapServerTestCase;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.populator.DefaultLdapAuthoritiesPopulator;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;

public class DefaultLdapAuthoritiesPopulatorTests
extends AbstractLdapServerTestCase {
    public void onSetUp() {
        this.getInitialCtxFactory().setManagerDn("cn=manager,dc=acegisecurity,dc=org");
        this.getInitialCtxFactory().setManagerPassword("acegisecurity");
    }

    public void testDefaultRoleIsAssignedWhenSet() {
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)this.getInitialCtxFactory(), "ou=groups");
        populator.setDefaultRole("ROLE_USER");
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setDn("cn=notfound");
        user.setUsername("notfound");
        user.setAttributes((Attributes)new BasicAttributes());
        GrantedAuthority[] authorities = populator.getGrantedAuthorities(user.createUserDetails());
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((int)1, (int)authorities.length);
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"ROLE_USER", (String)authorities[0].getAuthority());
    }

    public void testGroupSearchReturnsExpectedRoles() {
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)this.getInitialCtxFactory(), "ou=groups");
        populator.setRolePrefix("ROLE_");
        populator.setGroupRoleAttribute("ou");
        populator.setSearchSubtree(true);
        populator.setSearchSubtree(false);
        populator.setConvertToUpperCase(true);
        populator.setGroupSearchFilter("(member={0})");
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setUsername("ben");
        user.setDn("uid=ben,ou=people,dc=acegisecurity,dc=org");
        user.setAttributes((Attributes)new BasicAttributes());
        GrantedAuthority[] authorities = populator.getGrantedAuthorities(user.createUserDetails());
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"Should have 2 roles", (int)2, (int)authorities.length);
        HashSet<String> roles = new HashSet<String>();
        roles.add(authorities[0].toString());
        roles.add(authorities[1].toString());
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
    }

    public void testUseOfUsernameParameterReturnsExpectedRoles() {
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)this.getInitialCtxFactory(), "ou=groups");
        populator.setGroupRoleAttribute("ou");
        populator.setConvertToUpperCase(true);
        populator.setGroupSearchFilter("(ou={1})");
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setUsername("manager");
        user.setDn("uid=ben,ou=people,dc=acegisecurity,dc=org");
        GrantedAuthority[] authorities = populator.getGrantedAuthorities(user.createUserDetails());
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"Should have 1 role", (int)1, (int)authorities.length);
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"ROLE_MANAGER", (String)authorities[0].getAuthority());
    }

    public void testSubGroupRolesAreNotFoundByDefault() {
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)this.getInitialCtxFactory(), "ou=groups");
        populator.setGroupRoleAttribute("ou");
        populator.setConvertToUpperCase(true);
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setUsername("manager");
        user.setDn("uid=ben,ou=people,dc=acegisecurity,dc=org");
        GrantedAuthority[] authorities = populator.getGrantedAuthorities(user.createUserDetails());
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"Should have 2 roles", (int)2, (int)authorities.length);
        HashSet<String> roles = new HashSet<String>(2);
        roles.add(authorities[0].getAuthority());
        roles.add(authorities[1].getAuthority());
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
    }

    public void testSubGroupRolesAreFoundWhenSubtreeSearchIsEnabled() {
        DefaultLdapAuthoritiesPopulator populator = new DefaultLdapAuthoritiesPopulator((InitialDirContextFactory)this.getInitialCtxFactory(), "ou=groups");
        populator.setGroupRoleAttribute("ou");
        populator.setConvertToUpperCase(true);
        populator.setSearchSubtree(true);
        LdapUserDetailsImpl.Essence user = new LdapUserDetailsImpl.Essence();
        user.setUsername("manager");
        user.setDn("uid=ben,ou=people,dc=acegisecurity,dc=org");
        GrantedAuthority[] authorities = populator.getGrantedAuthorities(user.createUserDetails());
        DefaultLdapAuthoritiesPopulatorTests.assertEquals((String)"Should have 3 roles", (int)3, (int)authorities.length);
        HashSet<String> roles = new HashSet<String>(3);
        roles.add(authorities[0].getAuthority());
        roles.add(authorities[1].getAuthority());
        roles.add(authorities[2].getAuthority());
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_MANAGER"));
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_DEVELOPER"));
        DefaultLdapAuthoritiesPopulatorTests.assertTrue((boolean)roles.contains("ROLE_SUBMANAGER"));
    }
}

