/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.rcp;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.rcp.RemoteAuthenticationException;
import org.acegisecurity.providers.rcp.RemoteAuthenticationManager;
import org.acegisecurity.providers.rcp.RemoteAuthenticationProvider;

public class RemoteAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$rcp$RemoteAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$rcp$RemoteAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$rcp$RemoteAuthenticationProviderTests = RemoteAuthenticationProviderTests.class$("org.acegisecurity.providers.rcp.RemoteAuthenticationProviderTests")) : class$org$acegisecurity$providers$rcp$RemoteAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testExceptionsGetPassedBackToCaller() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(false));
        try {
            provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"password"));
            RemoteAuthenticationProviderTests.fail((String)"Should have thrown RemoteAuthenticationException");
        }
        catch (RemoteAuthenticationException expected) {
            RemoteAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        RemoteAuthenticationProviderTests.assertNotNull((Object)provider.getRemoteAuthenticationManager());
    }

    public void testStartupChecksAuthenticationManagerSet() throws Exception {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            RemoteAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RemoteAuthenticationProviderTests.assertTrue((boolean)true);
        }
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        provider.afterPropertiesSet();
        RemoteAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSuccessfulAuthenticationCreatesObject() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        provider.setRemoteAuthenticationManager((RemoteAuthenticationManager)new MockRemoteAuthenticationManager(true));
        Authentication result = provider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"password"));
        RemoteAuthenticationProviderTests.assertEquals((Object)"marissa", (Object)result.getPrincipal());
        RemoteAuthenticationProviderTests.assertEquals((Object)"password", (Object)result.getCredentials());
        RemoteAuthenticationProviderTests.assertEquals((String)"foo", (String)result.getAuthorities()[0].getAuthority());
    }

    public void testSupports() {
        RemoteAuthenticationProvider provider = new RemoteAuthenticationProvider();
        RemoteAuthenticationProviderTests.assertTrue((boolean)provider.supports(class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = RemoteAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockRemoteAuthenticationManager
    implements RemoteAuthenticationManager {
        private boolean grantAccess;

        public MockRemoteAuthenticationManager(boolean grantAccess) {
            this.grantAccess = grantAccess;
        }

        public GrantedAuthority[] attemptAuthentication(String username, String password) throws RemoteAuthenticationException {
            if (this.grantAccess) {
                return new GrantedAuthority[]{new GrantedAuthorityImpl("foo")};
            }
            throw new RemoteAuthenticationException("as requested");
        }
    }
}

