/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.rememberme;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationProvider;
import org.acegisecurity.providers.rememberme.RememberMeAuthenticationToken;

public class RememberMeAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationToken;

    public RememberMeAuthenticationProviderTests() {
    }

    public RememberMeAuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationProviderTests = RememberMeAuthenticationProviderTests.class$("org.acegisecurity.providers.rememberme.RememberMeAuthenticationProviderTests")) : class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsAnInvalidKey() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("WRONG_KEY", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        try {
            Authentication result = aap.authenticate((Authentication)token);
            RememberMeAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            RememberMeAuthenticationProviderTests.assertEquals((String)"The presented RememberMeAuthenticationToken does not contain the expected key", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingKey() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        try {
            aap.afterPropertiesSet();
            RememberMeAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        aap.afterPropertiesSet();
        RememberMeAuthenticationProviderTests.assertEquals((String)"qwerty", (String)aap.getKey());
    }

    public void testIgnoresClassesItDoesNotSupport() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        TestingAuthenticationToken token = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        RememberMeAuthenticationProviderTests.assertFalse((boolean)aap.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = RememberMeAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken));
        RememberMeAuthenticationProviderTests.assertNull((Object)aap.authenticate((Authentication)token));
    }

    public void testNormalOperation() throws Exception {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        aap.setKey("qwerty");
        RememberMeAuthenticationToken token = new RememberMeAuthenticationToken("qwerty", (Object)"Test", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        Authentication result = aap.authenticate((Authentication)token);
        RememberMeAuthenticationProviderTests.assertEquals((Object)result, (Object)token);
    }

    public void testSupports() {
        RememberMeAuthenticationProvider aap = new RememberMeAuthenticationProvider();
        RememberMeAuthenticationProviderTests.assertTrue((boolean)aap.supports(class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationToken == null ? (class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationToken = RememberMeAuthenticationProviderTests.class$("org.acegisecurity.providers.rememberme.RememberMeAuthenticationToken")) : class$org$acegisecurity$providers$rememberme$RememberMeAuthenticationToken));
        RememberMeAuthenticationProviderTests.assertFalse((boolean)aap.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = RememberMeAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

