/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.siteminder;

import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationServiceException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.LockedException;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.dao.UserCache;
import org.acegisecurity.providers.dao.cache.EhCacheBasedUserCache;
import org.acegisecurity.providers.siteminder.SiteminderAuthenticationProvider;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;

public class SiteminderAuthenticationProviderTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProviderTests;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$User;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache;
    static /* synthetic */ Class class$org$acegisecurity$providers$dao$cache$NullUserCache;
    static /* synthetic */ Class class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken;
    static /* synthetic */ Class class$org$acegisecurity$providers$TestingAuthenticationToken;

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProviderTests == null ? (class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProviderTests = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.providers.siteminder.SiteminderAuthenticationProviderTests")) : class$org$acegisecurity$providers$siteminder$SiteminderAuthenticationProviderTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticateFailsIfAccountExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserPeterAccountExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown AccountExpiredException");
        }
        catch (AccountExpiredException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfAccountLocked() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserPeterAccountLocked());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown LockedException");
        }
        catch (LockedException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfCredentialsExpired() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserPeterCredentialsExpired());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown CredentialsExpiredException");
        }
        catch (CredentialsExpiredException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsIfUserDisabled() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"peter", (Object)"opal");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserPeter());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown DisabledException");
        }
        catch (DisabledException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWhenUserDetailsServiceHasBackendFailure() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceSimulateBackendError());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithEmptyUsername() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(null, (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionFalse() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setHideUserNotFoundExceptions(false);
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithInvalidUsernameAndHideUserNotFoundExceptionsWithDefaultOfTrue() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"INVALID_USER", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        SiteminderAuthenticationProviderTests.assertTrue((boolean)provider.isHideUserNotFoundExceptions());
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticateFailsWithMixedCaseUsernameIfDefaultChanged() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"MaRiSSA", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testAuthenticates() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        token.setDetails((Object)"192.168.0.1");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            SiteminderAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        SiteminderAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$userdetails$User == null ? (class$org$acegisecurity$userdetails$User = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.userdetails.User")) : class$org$acegisecurity$userdetails$User), castResult.getPrincipal().getClass());
        SiteminderAuthenticationProviderTests.assertEquals((Object)"koala", (Object)castResult.getCredentials());
        SiteminderAuthenticationProviderTests.assertEquals((String)"ROLE_ONE", (String)castResult.getAuthorities()[0].getAuthority());
        SiteminderAuthenticationProviderTests.assertEquals((String)"ROLE_TWO", (String)castResult.getAuthorities()[1].getAuthority());
        SiteminderAuthenticationProviderTests.assertEquals((Object)"192.168.0.1", (Object)castResult.getDetails());
    }

    public void testAuthenticatesASecondTime() {
        Authentication result2;
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            SiteminderAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        if (!((result2 = provider.authenticate(result)) instanceof UsernamePasswordAuthenticationToken)) {
            SiteminderAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        SiteminderAuthenticationProviderTests.assertEquals((Object)result.getCredentials(), (Object)result2.getCredentials());
    }

    public void testAuthenticatesWithForcePrincipalAsString() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        provider.setUserCache((UserCache)new MockUserCache());
        provider.setForcePrincipalAsString(true);
        Authentication result = provider.authenticate((Authentication)token);
        if (!(result instanceof UsernamePasswordAuthenticationToken)) {
            SiteminderAuthenticationProviderTests.fail((String)"Should have returned instance of UsernamePasswordAuthenticationToken");
        }
        UsernamePasswordAuthenticationToken castResult = (UsernamePasswordAuthenticationToken)result;
        SiteminderAuthenticationProviderTests.assertEquals((Object)(class$java$lang$String == null ? (class$java$lang$String = SiteminderAuthenticationProviderTests.class$("java.lang.String")) : class$java$lang$String), castResult.getPrincipal().getClass());
        SiteminderAuthenticationProviderTests.assertEquals((Object)"marissa", (Object)castResult.getPrincipal());
    }

    public void testDetectsNullBeingReturnedFromUserDetailsService() {
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceReturnsNull());
        try {
            provider.authenticate((Authentication)token);
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown AuthenticationServiceException");
        }
        catch (AuthenticationServiceException expected) {
            SiteminderAuthenticationProviderTests.assertEquals((String)"UserDetailsService returned null, which is an interface contract violation", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserCache((UserCache)new EhCacheBasedUserCache());
        SiteminderAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache == null ? (class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.cache.EhCacheBasedUserCache")) : class$org$acegisecurity$providers$dao$cache$EhCacheBasedUserCache), provider.getUserCache().getClass());
        SiteminderAuthenticationProviderTests.assertFalse((boolean)provider.isForcePrincipalAsString());
        provider.setForcePrincipalAsString(true);
        SiteminderAuthenticationProviderTests.assertTrue((boolean)provider.isForcePrincipalAsString());
    }

    public void testStartupFailsIfNoUserDetailsService() throws Exception {
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfNoUserCacheSet() throws Exception {
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        provider.setUserDetailsService((UserDetailsService)new MockUserDetailsServiceUserMarissa());
        SiteminderAuthenticationProviderTests.assertEquals((Object)(class$org$acegisecurity$providers$dao$cache$NullUserCache == null ? (class$org$acegisecurity$providers$dao$cache$NullUserCache = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.providers.dao.cache.NullUserCache")) : class$org$acegisecurity$providers$dao$cache$NullUserCache), provider.getUserCache().getClass());
        provider.setUserCache(null);
        try {
            provider.afterPropertiesSet();
            SiteminderAuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccess() throws Exception {
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        MockUserDetailsServiceUserMarissa userDetailsService = new MockUserDetailsServiceUserMarissa();
        provider.setUserDetailsService((UserDetailsService)userDetailsService);
        provider.setUserCache((UserCache)new MockUserCache());
        SiteminderAuthenticationProviderTests.assertEquals((Object)userDetailsService, (Object)provider.getUserDetailsService());
        provider.afterPropertiesSet();
        SiteminderAuthenticationProviderTests.assertTrue((boolean)true);
    }

    public void testSupports() {
        SiteminderAuthenticationProvider provider = new SiteminderAuthenticationProvider();
        SiteminderAuthenticationProviderTests.assertTrue((boolean)provider.supports(class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken == null ? (class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.providers.UsernamePasswordAuthenticationToken")) : class$org$acegisecurity$providers$UsernamePasswordAuthenticationToken));
        SiteminderAuthenticationProviderTests.assertTrue((!provider.supports(class$org$acegisecurity$providers$TestingAuthenticationToken == null ? (class$org$acegisecurity$providers$TestingAuthenticationToken = SiteminderAuthenticationProviderTests.class$("org.acegisecurity.providers.TestingAuthenticationToken")) : class$org$acegisecurity$providers$TestingAuthenticationToken) ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockUserCache
    implements UserCache {
        private Map cache = new HashMap();

        private MockUserCache() {
        }

        public UserDetails getUserFromCache(String username) {
            return (User)this.cache.get(username);
        }

        public void putUserInCache(UserDetails user) {
            this.cache.put(user.getUsername(), user);
        }

        public void removeUserFromCache(String username) {
        }
    }

    private class MockUserDetailsServiceUserPeterCredentialsExpired
    implements UserDetailsService {
        private MockUserDetailsServiceUserPeterCredentialsExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockUserDetailsServiceUserPeterAccountLocked
    implements UserDetailsService {
        private MockUserDetailsServiceUserPeterAccountLocked() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, true, true, false, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockUserDetailsServiceUserPeterAccountExpired
    implements UserDetailsService {
        private MockUserDetailsServiceUserPeterAccountExpired() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockUserDetailsServiceUserPeter
    implements UserDetailsService {
        private MockUserDetailsServiceUserPeter() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("peter".equals(username)) {
                return new User("peter", "opal", false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockUserDetailsServiceUserMarissaWithSalt
    implements UserDetailsService {
        private MockUserDetailsServiceUserMarissaWithSalt() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("marissa".equals(username)) {
                return new User("marissa", "koala{SYSTEM_SALT_VALUE}", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }
    }

    private class MockUserDetailsServiceUserMarissa
    implements UserDetailsService {
        private String password = "koala";

        private MockUserDetailsServiceUserMarissa() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("marissa".equals(username)) {
                return new User("marissa", this.password, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    private class MockUserDetailsServiceSimulateBackendError
    implements UserDetailsService {
        private MockUserDetailsServiceSimulateBackendError() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            throw new DataRetrievalFailureException("This mock simulator is designed to fail");
        }
    }

    private class MockUserDetailsServiceReturnsNull
    implements UserDetailsService {
        private MockUserDetailsServiceReturnsNull() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            return null;
        }
    }
}

