/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.x509;

import java.security.cert.X509Certificate;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.providers.x509.X509AuthenticationProvider;
import org.acegisecurity.providers.x509.X509AuthenticationToken;
import org.acegisecurity.providers.x509.X509AuthoritiesPopulator;
import org.acegisecurity.providers.x509.X509TestUtils;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;

public class X509AuthenticationProviderTests
extends TestCase {
    public X509AuthenticationProviderTests() {
    }

    public X509AuthenticationProviderTests(String arg0) {
        super(arg0);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAuthenticationIsNullWithUnsupportedToken() {
        X509AuthenticationProvider provider = new X509AuthenticationProvider();
        UsernamePasswordAuthenticationToken request = new UsernamePasswordAuthenticationToken((Object)"dummy", (Object)"dummy");
        Authentication result = provider.authenticate((Authentication)request);
        X509AuthenticationProviderTests.assertNull((Object)result);
    }

    public void testFailsWithNullCertificate() {
        X509AuthenticationProvider provider = new X509AuthenticationProvider();
        provider.setX509AuthoritiesPopulator((X509AuthoritiesPopulator)new MockAuthoritiesPopulator(false));
        try {
            provider.authenticate((Authentication)new X509AuthenticationToken(null));
            X509AuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testNormalOperation() throws Exception {
        X509AuthenticationProvider provider = new X509AuthenticationProvider();
        provider.setX509AuthoritiesPopulator((X509AuthoritiesPopulator)new MockAuthoritiesPopulator(false));
        provider.afterPropertiesSet();
        Authentication result = provider.authenticate((Authentication)X509TestUtils.createToken());
        X509AuthenticationProviderTests.assertNotNull((Object)result);
        X509AuthenticationProviderTests.assertNotNull((Object)result.getAuthorities());
    }

    public void testPopulatorRejectionCausesFailure() throws Exception {
        X509AuthenticationProvider provider = new X509AuthenticationProvider();
        provider.setX509AuthoritiesPopulator((X509AuthoritiesPopulator)new MockAuthoritiesPopulator(true));
        try {
            provider.authenticate((Authentication)X509TestUtils.createToken());
            X509AuthenticationProviderTests.fail((String)"Should have thrown BadCredentialsException");
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
    }

    public void testRequiresPopulator() throws Exception {
        X509AuthenticationProvider provider = new X509AuthenticationProvider();
        try {
            provider.afterPropertiesSet();
            X509AuthenticationProviderTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public static class MockAuthoritiesPopulator
    implements X509AuthoritiesPopulator {
        private boolean rejectCertificate;

        public MockAuthoritiesPopulator(boolean rejectCertificate) {
            this.rejectCertificate = rejectCertificate;
        }

        public UserDetails getUserDetails(X509Certificate userCertificate) throws AuthenticationException {
            if (this.rejectCertificate) {
                throw new BadCredentialsException("Invalid Certificate");
            }
            return new User("user", "password", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A"), new GrantedAuthorityImpl("ROLE_B")});
        }
    }
}

