/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AuthenticationTag;
import org.acegisecurity.userdetails.User;

public class AuthenticationTagTests
extends TestCase {
    private final MyAuthenticationTag authenticationTag = new MyAuthenticationTag();

    public void testOperationAndMethodPrefixWhenPrincipalIsAUserDetailsInstance() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("username");
        this.authenticationTag.setMethodPrefix("get");
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
        AuthenticationTagTests.assertEquals((String)"marissaUserDetails", (String)this.authenticationTag.getLastMessage());
    }

    public void testOperationWhenPrincipalIsAString() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissaAsString", (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("principal");
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
        AuthenticationTagTests.assertEquals((String)"marissaAsString", (String)this.authenticationTag.getLastMessage());
    }

    public void testOperationWhenPrincipalIsAUserDetailsInstance() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("username");
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
        AuthenticationTagTests.assertEquals((String)"marissaUserDetails", (String)this.authenticationTag.getLastMessage());
    }

    public void testOperationWhenPrincipalIsNull() throws JspException {
        TestingAuthenticationToken auth = new TestingAuthenticationToken(null, (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("principal");
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
    }

    public void testOperationWhenSecurityContextIsNull() throws JspException {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authenticationTag.setOperation("principal");
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
        AuthenticationTagTests.assertEquals(null, (String)this.authenticationTag.getLastMessage());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testSkipsBodyIfNullOrEmptyOperation() throws Exception {
        this.authenticationTag.setOperation("");
        AuthenticationTagTests.assertEquals((String)"", (String)this.authenticationTag.getOperation());
        AuthenticationTagTests.assertEquals((int)0, (int)this.authenticationTag.doStartTag());
    }

    public void testThrowsExceptionForUnrecognisedMethodPrefix() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("username");
        this.authenticationTag.setMethodPrefix("qrq");
        try {
            this.authenticationTag.doStartTag();
            AuthenticationTagTests.fail((String)"Should have thrown a JspException");
        }
        catch (JspException expected) {
            AuthenticationTagTests.assertTrue((boolean)true);
        }
    }

    public void testThrowsExceptionForUnrecognisedOperation() {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[0]);
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        this.authenticationTag.setOperation("qsq");
        try {
            this.authenticationTag.doStartTag();
            AuthenticationTagTests.fail((String)"Should have throwns JspException");
        }
        catch (JspException expected) {
            AuthenticationTagTests.assertTrue((boolean)true);
        }
    }

    private class MyAuthenticationTag
    extends AuthenticationTag {
        String lastMessage = null;

        private MyAuthenticationTag() {
        }

        public String getLastMessage() {
            return this.lastMessage;
        }

        protected void writeMessage(String msg) throws JspException {
            this.lastMessage = msg;
        }
    }
}

