/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AuthorizeTag;

public class AuthorizeTagAttributeTests
extends TestCase {
    private final AuthorizeTag authorizeTag = new AuthorizeTag();
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SUPERVISOR"), new GrantedAuthorityImpl("ROLE_RESTRICTED")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAssertsIfAllGrantedSecond() throws JspException {
        this.authorizeTag.setIfAllGranted("ROLE_SUPERVISOR,ROLE_SUPERTELLER");
        this.authorizeTag.setIfAnyGranted("ROLE_RESTRICTED");
        AuthorizeTagAttributeTests.assertEquals((String)"prevents request - principal is missing ROLE_SUPERTELLER", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testAssertsIfAnyGrantedLast() throws JspException {
        this.authorizeTag.setIfAnyGranted("ROLE_BANKER");
        AuthorizeTagAttributeTests.assertEquals((String)"prevents request - principal is missing ROLE_BANKER", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testAssertsIfNotGrantedFirst() throws JspException {
        this.authorizeTag.setIfNotGranted("ROLE_RESTRICTED");
        this.authorizeTag.setIfAllGranted("ROLE_SUPERVISOR,ROLE_RESTRICTED");
        this.authorizeTag.setIfAnyGranted("ROLE_SUPERVISOR");
        AuthorizeTagAttributeTests.assertEquals((String)"prevents request - principal has ROLE_RESTRICTED", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testAssertsIfNotGrantedIgnoresWhitespaceInAttribute() throws JspException {
        this.authorizeTag.setIfAnyGranted("\tROLE_SUPERVISOR  \t, \r\n\t ROLE_TELLER ");
        AuthorizeTagAttributeTests.assertEquals((String)"allows request - principal has ROLE_SUPERVISOR", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testIfAllGrantedIgnoresWhitespaceInAttribute() throws JspException {
        this.authorizeTag.setIfAllGranted("\nROLE_SUPERVISOR\t,ROLE_RESTRICTED\t\n\r ");
        AuthorizeTagAttributeTests.assertEquals((String)"allows request - principal has ROLE_RESTRICTED and ROLE_SUPERVISOR", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testIfNotGrantedIgnoresWhitespaceInAttribute() throws JspException {
        this.authorizeTag.setIfNotGranted(" \t  ROLE_TELLER \r");
        AuthorizeTagAttributeTests.assertEquals((String)"allows request - principal does not have ROLE_TELLER", (int)1, (int)this.authorizeTag.doStartTag());
    }
}

