/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.authz;

import javax.servlet.jsp.JspException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.authz.AuthorizeTag;

public class AuthorizeTagTests
extends TestCase {
    private final AuthorizeTag authorizeTag = new AuthorizeTag();
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE SUPERVISOR"), new GrantedAuthorityImpl("ROLE_TELLER")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAlwaysReturnsUnauthorizedIfNoUserFound() throws JspException {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authorizeTag.setIfAllGranted("ROLE_TELLER");
        AuthorizeTagTests.assertEquals((String)"prevents request - no principal in Context", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testDefaultsToNotOutputtingBodyWhenNoRequiredAuthorities() throws JspException {
        AuthorizeTagTests.assertEquals((String)"", (String)this.authorizeTag.getIfAllGranted());
        AuthorizeTagTests.assertEquals((String)"", (String)this.authorizeTag.getIfAnyGranted());
        AuthorizeTagTests.assertEquals((String)"", (String)this.authorizeTag.getIfNotGranted());
        AuthorizeTagTests.assertEquals((String)"prevents body output - no authorities granted", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testOutputsBodyIfOneRolePresent() throws JspException {
        this.authorizeTag.setIfAnyGranted("ROLE_TELLER");
        AuthorizeTagTests.assertEquals((String)"authorized - ROLE_TELLER in both sets", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testOutputsBodyWhenAllGranted() throws JspException {
        this.authorizeTag.setIfAllGranted("ROLE SUPERVISOR,ROLE_TELLER");
        AuthorizeTagTests.assertEquals((String)"allows request - all required roles granted on principal", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testOutputsBodyWhenNotGrantedSatisfied() throws JspException {
        this.authorizeTag.setIfNotGranted("ROLE_BANKER");
        AuthorizeTagTests.assertEquals((String)"allows request - principal doesn't have ROLE_BANKER", (int)1, (int)this.authorizeTag.doStartTag());
    }

    public void testPreventsBodyOutputIfNoSecurityContext() throws JspException {
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authorizeTag.setIfAnyGranted("ROLE_BANKER");
        AuthorizeTagTests.assertEquals((String)"prevents output - no context defined", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testSkipsBodyIfNoAnyRolePresent() throws JspException {
        this.authorizeTag.setIfAnyGranted("ROLE_BANKER");
        AuthorizeTagTests.assertEquals((String)"unauthorized - ROLE_BANKER not in granted authorities", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testSkipsBodyWhenMissingAnAllGranted() throws JspException {
        this.authorizeTag.setIfAllGranted("ROLE SUPERVISOR,ROLE_TELLER,ROLE_BANKER");
        AuthorizeTagTests.assertEquals((String)"prevents request - missing ROLE_BANKER on principal", (int)0, (int)this.authorizeTag.doStartTag());
    }

    public void testSkipsBodyWhenNotGrantedUnsatisfied() throws JspException {
        this.authorizeTag.setIfNotGranted("ROLE_TELLER");
        AuthorizeTagTests.assertEquals((String)"prevents request - principal has ROLE_TELLER", (int)0, (int)this.authorizeTag.doStartTag());
    }
}

