/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.taglibs.velocity;

import javax.servlet.jsp.JspException;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.taglibs.velocity.Authz;
import org.acegisecurity.taglibs.velocity.AuthzImpl;

public class AuthzImplAttributeTest
extends TestCase {
    private final Authz authz = new AuthzImpl();
    private TestingAuthenticationToken currentUser;

    protected void setUp() throws Exception {
        super.setUp();
        this.currentUser = new TestingAuthenticationToken((Object)"abc", (Object)"123", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SUPERVISOR"), new GrantedAuthorityImpl("ROLE_RESTRICTED")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)this.currentUser);
    }

    protected void tearDown() throws Exception {
        SecurityContextHolder.clearContext();
    }

    public void testAssertsIfAllGrantedSecond() {
        boolean r1 = this.authz.allGranted("ROLE_SUPERVISOR,ROLE_SUPERTELLER");
        boolean r2 = this.authz.anyGranted("ROLE_RESTRICTED");
        AuthzImplAttributeTest.assertFalse((r1 && r2 ? 1 : 0) != 0);
    }

    public void testAssertsIfAnyGrantedLast() {
        boolean r2 = this.authz.anyGranted("ROLE_BANKER");
        AuthzImplAttributeTest.assertFalse((boolean)r2);
    }

    public void testAssertsIfNotGrantedFirst() {
        boolean r1 = this.authz.allGranted("ROLE_SUPERVISOR,ROLE_RESTRICTED");
        boolean r2 = this.authz.noneGranted("ROLE_RESTRICTED");
        boolean r3 = this.authz.anyGranted("ROLE_SUPERVISOR");
        AuthzImplAttributeTest.assertFalse((r1 && r2 && r3 ? 1 : 0) != 0);
    }

    public void testAssertsIfNotGrantedIgnoresWhitespaceInAttribute() {
        AuthzImplAttributeTest.assertTrue((boolean)this.authz.anyGranted("\tROLE_SUPERVISOR  \t, \r\n\t ROLE_TELLER "));
    }

    public void testIfAllGrantedIgnoresWhitespaceInAttribute() {
        AuthzImplAttributeTest.assertTrue((boolean)this.authz.allGranted("\nROLE_SUPERVISOR\t,ROLE_RESTRICTED\t\n\r "));
    }

    public void testIfNotGrantedIgnoresWhitespaceInAttribute() throws JspException {
        AuthzImplAttributeTest.assertFalse((boolean)this.authz.allGranted(" \t  ROLE_TELLER \r"));
    }
}

