/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.rememberme;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.ui.rememberme.RememberMeProcessingFilter;
import org.acegisecurity.ui.rememberme.RememberMeServices;
import org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class RememberMeProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilterTests;
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$NullRememberMeServices;
    static /* synthetic */ Class class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices;

    public RememberMeProcessingFilterTests() {
    }

    public RememberMeProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilterTests == null ? (class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilterTests = RememberMeProcessingFilterTests.class$("org.acegisecurity.ui.rememberme.RememberMeProcessingFilterTests")) : class$org$acegisecurity$ui$rememberme$RememberMeProcessingFilterTests));
    }

    protected void setUp() throws Exception {
        super.setUp();
        SecurityContextHolder.clearContext();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        SecurityContextHolder.clearContext();
    }

    public void testDetectsAuthenticationManagerProperty() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.afterPropertiesSet();
        RememberMeProcessingFilterTests.assertTrue((boolean)true);
        filter.setAuthenticationManager(null);
        try {
            filter.afterPropertiesSet();
            RememberMeProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsRememberMeServicesProperty() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        RememberMeProcessingFilterTests.assertEquals((Object)(class$org$acegisecurity$ui$rememberme$NullRememberMeServices == null ? (class$org$acegisecurity$ui$rememberme$NullRememberMeServices = RememberMeProcessingFilterTests.class$("org.acegisecurity.ui.rememberme.NullRememberMeServices")) : class$org$acegisecurity$ui$rememberme$NullRememberMeServices), filter.getRememberMeServices().getClass());
        filter.setRememberMeServices((RememberMeServices)new TokenBasedRememberMeServices());
        RememberMeProcessingFilterTests.assertEquals((Object)(class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices == null ? (class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices = RememberMeProcessingFilterTests.class$("org.acegisecurity.ui.rememberme.TokenBasedRememberMeServices")) : class$org$acegisecurity$ui$rememberme$TokenBasedRememberMeServices), filter.getRememberMeServices().getClass());
        filter.setRememberMeServices(null);
        try {
            filter.afterPropertiesSet();
            RememberMeProcessingFilterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            RememberMeProcessingFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDoFilterWithNonHttpServletRequestDetected() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        try {
            filter.doFilter(null, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain());
            RememberMeProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            RememberMeProcessingFilterTests.assertEquals((String)"Can only process HttpServletRequest", (String)expected.getMessage());
        }
    }

    public void testDoFilterWithNonHttpServletResponseDetected() throws Exception {
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        try {
            MockHttpServletRequest request = new MockHttpServletRequest();
            request.setRequestURI("dc");
            filter.doFilter((ServletRequest)request, null, (FilterChain)new MockFilterChain());
            RememberMeProcessingFilterTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            RememberMeProcessingFilterTests.assertEquals((String)"Can only process HttpServletResponse", (String)expected.getMessage());
        }
    }

    public void testOperationWhenAuthenticationExistsInContextHolder() throws Exception {
        TestingAuthenticationToken originalAuth = new TestingAuthenticationToken((Object)"user", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_A")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)originalAuth);
        TestingAuthenticationToken remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_REMEMBERED")});
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices((Authentication)remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeProcessingFilterTests.assertEquals((Object)originalAuth, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testOperationWhenNoAuthenticationInContextHolder() throws Exception {
        TestingAuthenticationToken remembered = new TestingAuthenticationToken((Object)"remembered", (Object)"password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_REMEMBERED")});
        RememberMeProcessingFilter filter = new RememberMeProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)new MockAuthenticationManager());
        filter.setRememberMeServices((RememberMeServices)new MockRememberMeServices((Authentication)remembered));
        filter.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("x");
        this.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)new MockHttpServletResponse(), new MockFilterChain(true));
        RememberMeProcessingFilterTests.assertEquals((Object)remembered, (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockRememberMeServices
    implements RememberMeServices {
        private Authentication authToReturn;

        public MockRememberMeServices(Authentication authToReturn) {
            this.authToReturn = authToReturn;
        }

        public Authentication autoLogin(HttpServletRequest request, HttpServletResponse response) {
            return this.authToReturn;
        }

        public void loginFail(HttpServletRequest request, HttpServletResponse response) {
        }

        public void loginSuccess(HttpServletRequest request, HttpServletResponse response, Authentication successfulAuthentication) {
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

