/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.switchuser;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.AccountExpiredException;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.CredentialsExpiredException;
import org.acegisecurity.DisabledException;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.ui.switchuser.SwitchUserGrantedAuthority;
import org.acegisecurity.ui.switchuser.SwitchUserProcessingFilter;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.util.MockFilterChain;
import org.springframework.dao.DataAccessException;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class SwitchUserProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilterTests;

    public SwitchUserProcessingFilterTests() {
    }

    public SwitchUserProcessingFilterTests(String arg0) {
        super(arg0);
    }

    private MockHttpServletRequest createMockSwitchRequest() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerName("localhost");
        request.setRequestURI("/j_acegi_switch_user");
        return request;
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilterTests == null ? (class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilterTests = SwitchUserProcessingFilterTests.class$("org.acegisecurity.ui.switchuser.SwitchUserProcessingFilterTests")) : class$org$acegisecurity$ui$switchuser$SwitchUserProcessingFilterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAttemptSwitchToUnknownUser() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "user-that-doesnt-exist");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        try {
            Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
            SwitchUserProcessingFilterTests.fail((String)"Should not be able to switch to unknown user");
        }
        catch (UsernameNotFoundException expected) {
            // empty catch block
        }
    }

    public void testAttemptSwitchToUserThatIsDisabled() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "mcgarrett");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        try {
            Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
            SwitchUserProcessingFilterTests.fail((String)"Should not be able to switch to disabled user");
        }
        catch (DisabledException expected) {
            // empty catch block
        }
    }

    public void testAttemptSwitchToUserWithAccountExpired() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "wofat");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        try {
            Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
            SwitchUserProcessingFilterTests.fail((String)"Should not be able to switch to user with expired account");
        }
        catch (AccountExpiredException expected) {
            // empty catch block
        }
    }

    public void testAttemptSwitchToUserWithExpiredCredentials() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "steve");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        try {
            Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
            SwitchUserProcessingFilterTests.fail((String)"Should not be able to switch to user with expired account");
        }
        catch (CredentialsExpiredException expected) {
            // empty catch block
        }
    }

    public void testAttemptSwitchUser() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "jacklord");
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        Authentication result = filter.attemptSwitchUser((HttpServletRequest)request);
        SwitchUserProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testIfSwitchUserWithNullUsernameThrowsException() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        String username = null;
        request.addParameter("j_username", username);
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        Authentication result = null;
        try {
            result = filter.attemptSwitchUser((HttpServletRequest)request);
            SwitchUserProcessingFilterTests.fail((String)"UsernameNotFoundException should have been thrown");
        }
        catch (UsernameNotFoundException e) {
            // empty catch block
        }
        SwitchUserProcessingFilterTests.assertFalse((result != null ? 1 : 0) != 0);
    }

    public void testBadConfigMissingAuthenticationDao() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        filter.setExitUserUrl("/j_acegi_exit_user");
        filter.setTargetUrl("/main.jsp");
        try {
            filter.afterPropertiesSet();
            SwitchUserProcessingFilterTests.fail((String)"Expect to fail due to missing 'authenticationDao'");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testBadConfigMissingTargetUrl() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        filter.setExitUserUrl("/j_acegi_exit_user");
        try {
            filter.afterPropertiesSet();
            SwitchUserProcessingFilterTests.fail((String)"Expect to fail due to missing 'targetUrl'");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testDefaultProcessesFilterUrlWithPathParameter() {
        MockHttpServletRequest request = this.createMockSwitchRequest();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        request.setRequestURI("/webapp/j_acegi_switch_user;jsessionid=8JHDUD723J8");
        SwitchUserProcessingFilterTests.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    public void testExitRequestUserJackLordToDano() throws Exception {
        GrantedAuthority[] auths = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")};
        UsernamePasswordAuthenticationToken source = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50", auths);
        GrantedAuthority[] adminAuths = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO"), new SwitchUserGrantedAuthority("PREVIOUS_ADMINISTRATOR", (Authentication)source)};
        UsernamePasswordAuthenticationToken admin = new UsernamePasswordAuthenticationToken((Object)"jacklord", (Object)"hawaii50", adminAuths);
        SecurityContextHolder.getContext().setAuthentication((Authentication)admin);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_acegi_exit_user");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        filter.setExitUserUrl("/j_acegi_exit_user");
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        SwitchUserProcessingFilterTests.assertNotNull((Object)targetAuth);
        SwitchUserProcessingFilterTests.assertEquals((Object)"dano", (Object)targetAuth.getPrincipal());
    }

    public void testExitUserWithNoCurrentUser() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.setRequestURI("/j_acegi_exit_user");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        filter.setExitUserUrl("/j_acegi_exit_user");
        MockFilterChain chain = new MockFilterChain(true);
        try {
            filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
            SwitchUserProcessingFilterTests.fail((String)"Cannot exit from a user with no current user set!");
        }
        catch (AuthenticationException expected) {
            // empty catch block
        }
    }

    public void testRedirectToTargetUrl() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = this.createMockSwitchRequest();
        request.addParameter("j_username", "jacklord");
        request.setRequestURI("/webapp/j_acegi_switch_user");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(true);
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        filter.setTargetUrl("/webapp/someOtherUrl");
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        SwitchUserProcessingFilterTests.assertEquals((String)"/webapp/someOtherUrl", (String)response.getRedirectedUrl());
    }

    public void testRequiresExitUser() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setExitUserUrl("/j_acegi_exit_user");
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/j_acegi_exit_user");
        SwitchUserProcessingFilterTests.assertTrue((boolean)filter.requiresExitUser((HttpServletRequest)request));
    }

    public void testRequiresSwitch() {
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        MockHttpServletRequest request = this.createMockSwitchRequest();
        SwitchUserProcessingFilterTests.assertTrue((boolean)filter.requiresSwitchUser((HttpServletRequest)request));
    }

    public void testSwitchRequestFromDanoToJackLord() throws Exception {
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)"dano", (Object)"hawaii50");
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/webapp/j_acegi_switch_user");
        request.addParameter("j_username", "jacklord");
        MockHttpServletResponse response = new MockHttpServletResponse();
        SwitchUserProcessingFilter filter = new SwitchUserProcessingFilter();
        filter.setUserDetailsService((UserDetailsService)new MockAuthenticationDaoUserJackLord());
        filter.setSwitchUserUrl("/j_acegi_switch_user");
        MockFilterChain chain = new MockFilterChain(true);
        filter.doFilter((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        Authentication targetAuth = SecurityContextHolder.getContext().getAuthentication();
        SwitchUserProcessingFilterTests.assertNotNull((Object)targetAuth);
        SwitchUserProcessingFilterTests.assertTrue((boolean)(targetAuth.getPrincipal() instanceof UserDetails));
        SwitchUserProcessingFilterTests.assertEquals((String)"jacklord", (String)((User)targetAuth.getPrincipal()).getUsername());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAuthenticationDaoUserJackLord
    implements UserDetailsService {
        private String password = "hawaii50";

        private MockAuthenticationDaoUserJackLord() {
        }

        public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
            if ("jacklord".equals(username) || "dano".equals(username)) {
                return new User(username, this.password, true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("mcgarrett".equals(username)) {
                return new User(username, this.password, false, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("wofat".equals(username)) {
                return new User(username, this.password, true, false, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            if ("steve".equals(username)) {
                return new User(username, this.password, true, true, false, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
            }
            throw new UsernameNotFoundException("Could not find: " + username);
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

