/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.webapp;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.ui.webapp.AuthenticationProcessingFilter;
import org.springframework.mock.web.MockHttpServletRequest;

public class AuthenticationProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterTests;

    public AuthenticationProcessingFilterTests() {
    }

    public AuthenticationProcessingFilterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterTests == null ? (class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterTests = AuthenticationProcessingFilterTests.class$("org.acegisecurity.ui.webapp.AuthenticationProcessingFilterTests")) : class$org$acegisecurity$ui$webapp$AuthenticationProcessingFilterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGetters() {
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        AuthenticationProcessingFilterTests.assertEquals((String)"/j_acegi_security_check", (String)filter.getDefaultFilterProcessesUrl());
    }

    public void testNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "marissa");
        request.addParameter("j_password", "koala");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        AuthenticationProcessingFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    public void testNullPasswordHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "marissa");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testNullUsernameHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_password", "koala");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        AuthenticationProcessingFilter filter = new AuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        AuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

