/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.ui.webapp;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.MockAuthenticationManager;
import org.acegisecurity.ui.WebAuthenticationDetails;
import org.acegisecurity.ui.webapp.SiteminderAuthenticationProcessingFilter;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class SiteminderAuthenticationProcessingFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilterTests;

    public SiteminderAuthenticationProcessingFilterTests() {
    }

    public SiteminderAuthenticationProcessingFilterTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilterTests == null ? (class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilterTests = SiteminderAuthenticationProcessingFilterTests.class$("org.acegisecurity.ui.webapp.SiteminderAuthenticationProcessingFilterTests")) : class$org$acegisecurity$ui$webapp$SiteminderAuthenticationProcessingFilterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAccessors() {
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setAlwaysUseDefaultTargetUrl(true);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((boolean)filter.isAlwaysUseDefaultTargetUrl());
        filter.setAuthenticationFailureUrl("foo");
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"foo", (String)filter.getAuthenticationFailureUrl());
        filter.setContinueChainBeforeSuccessfulAuthentication(true);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((boolean)filter.isContinueChainBeforeSuccessfulAuthentication());
        filter.setDefaultTargetUrl("/bar");
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"/bar", (String)filter.getDefaultTargetUrl());
        filter.setFilterProcessesUrl("foobar");
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"foobar", (String)filter.getFilterProcessesUrl());
        filter.setFormUsernameParameterKey("usernameParamKey");
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"usernameParamKey", (String)filter.getFormUsernameParameterKey());
        filter.setSiteminderUsernameHeaderKey("usernameHeaderKey");
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"usernameHeaderKey", (String)filter.getSiteminderUsernameHeaderKey());
    }

    public void testFormNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "marissa");
        request.addParameter("j_password", "koala");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    public void testFormNullPasswordHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_username", "marissa");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testFormNullUsernameHandledGracefully() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("j_password", "koala");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
    }

    public void testRequiresAuthentication() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        request.addHeader("SM_USER", (Object)"A123456");
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setDefaultTargetUrl("/defaultTargetUri");
        MockAuthenticationManager authMgrThatGrantsAccess = new MockAuthenticationManager(true);
        filter.setAuthenticationManager((AuthenticationManager)authMgrThatGrantsAccess);
        filter.setSiteminderUsernameHeaderKey("SM_USER");
        filter.init(null);
        request.setRequestURI("http://an.unknown.url");
        boolean requiresAuthentication = filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
        SiteminderAuthenticationProcessingFilterTests.assertFalse((boolean)requiresAuthentication);
        request.setRequestURI(request.getContextPath() + filter.getFilterProcessesUrl());
        requiresAuthentication = filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((boolean)requiresAuthentication);
        request.setRequestURI(request.getContextPath() + filter.getDefaultTargetUrl());
        requiresAuthentication = filter.requiresAuthentication((HttpServletRequest)request, (HttpServletResponse)response);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((boolean)requiresAuthentication);
    }

    public void testSiteminderNormalOperation() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("SM_USER", (Object)"A123456");
        MockAuthenticationManager authMgr = new MockAuthenticationManager(true);
        SiteminderAuthenticationProcessingFilter filter = new SiteminderAuthenticationProcessingFilter();
        filter.setAuthenticationManager((AuthenticationManager)authMgr);
        filter.setSiteminderUsernameHeaderKey("SM_USER");
        filter.init(null);
        Authentication result = filter.attemptAuthentication((HttpServletRequest)request);
        SiteminderAuthenticationProcessingFilterTests.assertTrue((result != null ? 1 : 0) != 0);
        SiteminderAuthenticationProcessingFilterTests.assertEquals((String)"127.0.0.1", (String)((WebAuthenticationDetails)result.getDetails()).getRemoteAddress());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

