/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.PopulatedDatabase;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.jdbc.JdbcDaoImpl;
import org.springframework.jdbc.object.MappingSqlQuery;

public class JdbcDaoTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$userdetails$jdbc$JdbcDaoTests;

    public JdbcDaoTests() {
    }

    public JdbcDaoTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$userdetails$jdbc$JdbcDaoTests == null ? (class$org$acegisecurity$userdetails$jdbc$JdbcDaoTests = JdbcDaoTests.class$("org.acegisecurity.userdetails.jdbc.JdbcDaoTests")) : class$org$acegisecurity$userdetails$jdbc$JdbcDaoTests));
    }

    private JdbcDaoImpl makePopulatedJdbcDao() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.afterPropertiesSet();
        return dao;
    }

    private JdbcDaoImpl makePopulatedJdbcDaoWithRolePrefix() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.setRolePrefix("ARBITRARY_PREFIX_");
        dao.afterPropertiesSet();
        return dao;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCheckDaoAccessUserSuccess() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("marissa");
        JdbcDaoTests.assertEquals((String)"marissa", (String)user.getUsername());
        JdbcDaoTests.assertEquals((String)"koala", (String)user.getPassword());
        JdbcDaoTests.assertTrue((boolean)user.isEnabled());
        HashSet<String> authorities = new HashSet<String>(2);
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        JdbcDaoTests.assertTrue((boolean)authorities.contains("ROLE_TELLER"));
        JdbcDaoTests.assertTrue((boolean)authorities.contains("ROLE_SUPERVISOR"));
    }

    public void testCheckDaoOnlyReturnsGrantedAuthoritiesGrantedToUser() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("scott");
        JdbcDaoTests.assertEquals((String)"ROLE_TELLER", (String)user.getAuthorities()[0].getAuthority());
        JdbcDaoTests.assertEquals((int)1, (int)user.getAuthorities().length);
    }

    public void testCheckDaoReturnsCorrectDisabledProperty() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        UserDetails user = dao.loadUserByUsername("peter");
        JdbcDaoTests.assertTrue((!user.isEnabled() ? 1 : 0) != 0);
    }

    public void testGettersSetters() {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setAuthoritiesByUsernameQuery("SELECT * FROM FOO");
        JdbcDaoTests.assertEquals((String)"SELECT * FROM FOO", (String)dao.getAuthoritiesByUsernameQuery());
        dao.setUsersByUsernameQuery("SELECT USERS FROM FOO");
        JdbcDaoTests.assertEquals((String)"SELECT USERS FROM FOO", (String)dao.getUsersByUsernameQuery());
    }

    public void testLookupFailsIfUserHasNoGrantedAuthorities() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        try {
            dao.loadUserByUsername("cooper");
            JdbcDaoTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            JdbcDaoTests.assertEquals((String)"User has no GrantedAuthority", (String)expected.getMessage());
        }
    }

    public void testLookupFailsWithWrongUsername() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        try {
            dao.loadUserByUsername("UNKNOWN_USER");
            JdbcDaoTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            JdbcDaoTests.assertTrue((boolean)true);
        }
    }

    public void testLookupSuccessWithMixedCase() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        JdbcDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("MaRiSSA").getPassword());
        JdbcDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("ScOTt").getPassword());
    }

    public void testRolePrefixWorks() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDaoWithRolePrefix();
        JdbcDaoTests.assertEquals((String)"ARBITRARY_PREFIX_", (String)dao.getRolePrefix());
        UserDetails user = dao.loadUserByUsername("marissa");
        JdbcDaoTests.assertEquals((String)"marissa", (String)user.getUsername());
        JdbcDaoTests.assertEquals((int)2, (int)user.getAuthorities().length);
        HashSet<String> authorities = new HashSet<String>(2);
        authorities.add(user.getAuthorities()[0].getAuthority());
        authorities.add(user.getAuthorities()[1].getAuthority());
        JdbcDaoTests.assertTrue((boolean)authorities.contains("ARBITRARY_PREFIX_ROLE_TELLER"));
        JdbcDaoTests.assertTrue((boolean)authorities.contains("ARBITRARY_PREFIX_ROLE_SUPERVISOR"));
    }

    public void testStartupFailsIfDataSourceNotSet() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        try {
            dao.afterPropertiesSet();
            JdbcDaoTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcDaoTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfUserMapSetToNull() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        try {
            dao.setDataSource(null);
            dao.afterPropertiesSet();
            JdbcDaoTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcDaoTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockMappingSqlQuery
    extends MappingSqlQuery {
        private MockMappingSqlQuery() {
        }

        protected Object mapRow(ResultSet arg0, int arg1) throws SQLException {
            return null;
        }
    }
}

