/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.ldap;

import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import junit.framework.TestCase;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsImpl;
import org.acegisecurity.userdetails.ldap.LdapUserDetailsMapper;

public class LdapUserDetailsMapperTests
extends TestCase {
    public void testMultipleRoleAttributeValuesAreMappedToAuthorities() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setConvertToUpperCase(false);
        mapper.setRolePrefix("");
        mapper.setRoleAttributes(new String[]{"userRole"});
        BasicAttributes attrs = new BasicAttributes();
        BasicAttribute roleAttribute = new BasicAttribute("userRole");
        roleAttribute.add("X");
        roleAttribute.add("Y");
        roleAttribute.add("Z");
        attrs.put(roleAttribute);
        LdapUserDetailsImpl.Essence user = (LdapUserDetailsImpl.Essence)mapper.mapAttributes("cn=someName", (Attributes)attrs);
        LdapUserDetailsMapperTests.assertEquals((int)3, (int)user.getGrantedAuthorities().length);
    }

    public void testNonRetrievedRoleAttributeIsIgnored() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setRoleAttributes(new String[]{"userRole", "nonRetrievedAttribute"});
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("userRole", "x"));
        LdapUserDetailsImpl.Essence user = (LdapUserDetailsImpl.Essence)mapper.mapAttributes("cn=someName", (Attributes)attrs);
        LdapUserDetailsMapperTests.assertEquals((int)1, (int)user.getGrantedAuthorities().length);
        LdapUserDetailsMapperTests.assertEquals((String)"ROLE_X", (String)user.getGrantedAuthorities()[0].getAuthority());
    }

    public void testNonStringRoleAttributeIsIgnoredByDefault() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setRoleAttributes(new String[]{"userRole"});
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("userRole", new GrantedAuthorityImpl("X")));
        LdapUserDetailsImpl.Essence user = (LdapUserDetailsImpl.Essence)mapper.mapAttributes("cn=someName", (Attributes)attrs);
        LdapUserDetailsMapperTests.assertEquals((int)0, (int)user.getGrantedAuthorities().length);
    }

    public void testPasswordAttributeIsMappedCorrectly() throws Exception {
        LdapUserDetailsMapper mapper = new LdapUserDetailsMapper();
        mapper.setPasswordAttributeName("myappsPassword");
        BasicAttributes attrs = new BasicAttributes();
        attrs.put(new BasicAttribute("myappsPassword", "mypassword".getBytes()));
        LdapUserDetails user = ((LdapUserDetailsImpl.Essence)mapper.mapAttributes("cn=someName", (Attributes)attrs)).createUserDetails();
        LdapUserDetailsMapperTests.assertEquals((String)"mypassword", (String)user.getPassword());
    }
}

