/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.memory;

import java.util.Properties;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.InMemoryDaoImpl;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;

public class InMemoryDaoTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$userdetails$memory$InMemoryDaoTests;

    public InMemoryDaoTests() {
    }

    public InMemoryDaoTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$userdetails$memory$InMemoryDaoTests == null ? (class$org$acegisecurity$userdetails$memory$InMemoryDaoTests = InMemoryDaoTests.class$("org.acegisecurity.userdetails.memory.InMemoryDaoTests")) : class$org$acegisecurity$userdetails$memory$InMemoryDaoTests));
    }

    private UserMap makeUserMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("marissa=koala,ROLE_ONE,ROLE_TWO,enabled\r\nscott=wombat,ROLE_ONE,ROLE_TWO,enabled");
        return (UserMap)editor.getValue();
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testLookupFails() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        try {
            dao.loadUserByUsername("UNKNOWN_USER");
            InMemoryDaoTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testLookupSuccess() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("marissa").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("scott").getPassword());
    }

    public void testLookupSuccessWithMixedCase() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("MaRiSSA").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("ScOTt").getPassword());
    }

    public void testStartupFailsIfUserMapNotSet() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        try {
            dao.afterPropertiesSet();
            InMemoryDaoTests.fail((String)"Shoudl have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testStartupFailsIfUserMapSetToNull() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(null);
        try {
            dao.afterPropertiesSet();
            InMemoryDaoTests.fail((String)"Shoudl have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InMemoryDaoTests.assertTrue((boolean)true);
        }
    }

    public void testStartupSuccessIfUserMapSet() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        dao.setUserMap(this.makeUserMap());
        dao.afterPropertiesSet();
        InMemoryDaoTests.assertEquals((int)2, (int)dao.getUserMap().getUserCount());
    }

    public void testUseOfExternalPropertiesObject() throws Exception {
        InMemoryDaoImpl dao = new InMemoryDaoImpl();
        Properties props = new Properties();
        props.put("marissa", "koala,ROLE_ONE,ROLE_TWO,enabled");
        props.put("scott", "wombat,ROLE_ONE,ROLE_TWO,enabled");
        dao.setUserProperties(props);
        InMemoryDaoTests.assertEquals((String)"koala", (String)dao.loadUserByUsername("marissa").getPassword());
        InMemoryDaoTests.assertEquals((String)"wombat", (String)dao.loadUserByUsername("scott").getPassword());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

