/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.memory;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.userdetails.memory.UserMap;
import org.acegisecurity.userdetails.memory.UserMapEditor;

public class UserMapEditorTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$userdetails$memory$UserMapEditorTests;

    public UserMapEditorTests() {
    }

    public UserMapEditorTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$userdetails$memory$UserMapEditorTests == null ? (class$org$acegisecurity$userdetails$memory$UserMapEditorTests = UserMapEditorTests.class$("org.acegisecurity.userdetails.memory.UserMapEditorTests")) : class$org$acegisecurity$userdetails$memory$UserMapEditorTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testConvertedIntoUserSuccessfullyWhenDisabled() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("marissa=koala,ROLE_ONE,ROLE_TWO,disabled");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertTrue((!map.getUser("marissa").isEnabled() ? 1 : 0) != 0);
    }

    public void testConvertedIntoUserSuccessfullyWhenEnabled() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("marissa=koala,ROLE_ONE,ROLE_TWO");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((String)"marissa", (String)map.getUser("marissa").getUsername());
        UserMapEditorTests.assertEquals((String)"koala", (String)map.getUser("marissa").getPassword());
        UserMapEditorTests.assertEquals((String)"ROLE_ONE", (String)map.getUser("marissa").getAuthorities()[0].getAuthority());
        UserMapEditorTests.assertEquals((String)"ROLE_TWO", (String)map.getUser("marissa").getAuthorities()[1].getAuthority());
        UserMapEditorTests.assertTrue((boolean)map.getUser("marissa").isEnabled());
    }

    public void testEmptyStringReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }

    public void testMalformedStringReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("MALFORMED_STRING");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }

    public void testMultiUserParsing() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText("marissa=koala,ROLE_ONE,ROLE_TWO,enabled\r\nscott=wombat,ROLE_ONE,ROLE_TWO,enabled");
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((String)"marissa", (String)map.getUser("marissa").getUsername());
        UserMapEditorTests.assertEquals((String)"scott", (String)map.getUser("scott").getUsername());
    }

    public void testNullReturnsEmptyMap() {
        UserMapEditor editor = new UserMapEditor();
        editor.setAsText(null);
        UserMap map = (UserMap)editor.getValue();
        UserMapEditorTests.assertEquals((int)0, (int)map.getUserCount());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

