/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.userdetails.memory;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.acegisecurity.userdetails.memory.UserMap;

public class UserMapTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$userdetails$memory$UserMapTests;

    public UserMapTests() {
    }

    public UserMapTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$userdetails$memory$UserMapTests == null ? (class$org$acegisecurity$userdetails$memory$UserMapTests = UserMapTests.class$("org.acegisecurity.userdetails.memory.UserMapTests")) : class$org$acegisecurity$userdetails$memory$UserMapTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAddAndRetrieveUser() {
        User marissa = new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        User scott = new User("scott", "wombat", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_THREE")});
        User peter = new User("peter", "opal", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_FOUR")});
        UserMap map = new UserMap();
        map.addUser((UserDetails)marissa);
        map.addUser((UserDetails)scott);
        map.addUser((UserDetails)peter);
        UserMapTests.assertEquals((int)3, (int)map.getUserCount());
        UserMapTests.assertEquals((Object)marissa, (Object)map.getUser("marissa"));
        UserMapTests.assertEquals((Object)scott, (Object)map.getUser("scott"));
        UserMapTests.assertEquals((Object)peter, (Object)map.getUser("peter"));
    }

    public void testNullUserCannotBeAdded() {
        UserMap map = new UserMap();
        UserMapTests.assertEquals((int)0, (int)map.getUserCount());
        try {
            map.addUser(null);
            UserMapTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            UserMapTests.assertTrue((boolean)true);
        }
    }

    public void testUnknownUserIsNotRetrieved() {
        User marissa = new User("marissa", "koala", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        UserMap map = new UserMap();
        UserMapTests.assertEquals((int)0, (int)map.getUserCount());
        map.addUser((UserDetails)marissa);
        UserMapTests.assertEquals((int)1, (int)map.getUserCount());
        try {
            map.getUser("scott");
            UserMapTests.fail((String)"Should have thrown UsernameNotFoundException");
        }
        catch (UsernameNotFoundException expected) {
            UserMapTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

