/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.util.FilterToBeanProxy;
import org.acegisecurity.util.MockFilterChain;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterToBeanProxyTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$util$FilterToBeanProxyTests;

    public FilterToBeanProxyTests() {
    }

    public FilterToBeanProxyTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$util$FilterToBeanProxyTests == null ? (class$org$acegisecurity$util$FilterToBeanProxyTests = FilterToBeanProxyTests.class$("org.acegisecurity.util.FilterToBeanProxyTests")) : class$org$acegisecurity$util$FilterToBeanProxyTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsClassNotInClassLoader() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "net.sf.DOES.NOT.EXIST");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Class of type net.sf.DOES.NOT.EXIST not found in classloader", (String)expected.getMessage());
        }
    }

    public void testDetectsNeitherPropertyBeingSet() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"targetClass or targetBean must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetBeanIsNotAFilter() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.acegisecurity.util.MockNotAFilter");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Bean 'mockNotAFilter' does not implement javax.servlet.Filter", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetBeanNotInBeanContext() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "WRONG_NAME");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"targetBean 'WRONG_NAME' not found in context", (String)expected.getMessage());
        }
    }

    public void testDetectsTargetClassNotInBeanContext() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.acegisecurity.util.FilterToBeanProxyTests");
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        try {
            filter.init(config);
            FilterToBeanProxyTests.fail((String)"Should have thrown ServletException");
        }
        catch (ServletException expected) {
            FilterToBeanProxyTests.assertEquals((String)"Bean context must contain at least one bean of type org.acegisecurity.util.FilterToBeanProxyTests", (String)expected.getMessage());
        }
    }

    public void testIgnoresEmptyTargetBean() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.acegisecurity.util.MockFilter");
        config.setInitParmeter("targetBean", "");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithLazyTrue() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "mockFilter");
        config.setInitParmeter("init", "lazy");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithSpecificBeanName() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "mockFilter");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNormalOperationWithTargetClass() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetClass", "org.acegisecurity.util.MockFilter");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        this.executeFilterInContainerSimulator(config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
    }

    public void testNullDelegateDoesNotCauseNullPointerException() throws Exception {
        MockFilterConfig config = new MockFilterConfig();
        config.setInitParmeter("targetBean", "aFilterThatDoesntExist");
        config.setInitParmeter("init", "lazy");
        MockFilterChain chain = new MockFilterChain(true);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockFilterToBeanProxy filter = new MockFilterToBeanProxy("org/acegisecurity/util/filtertest-valid.xml");
        filter.destroy();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterToBeanProxy
    extends FilterToBeanProxy {
        private String appContextLocation;

        public MockFilterToBeanProxy(String appContextLocation) {
            this.appContextLocation = appContextLocation;
        }

        private MockFilterToBeanProxy() {
        }

        protected ApplicationContext getContext(FilterConfig filterConfig) {
            return new ClassPathXmlApplicationContext(this.appContextLocation);
        }
    }
}

