/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.util;

import javax.servlet.ServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.util.PortMapper;
import org.acegisecurity.util.PortMapperImpl;
import org.acegisecurity.util.PortResolverImpl;
import org.springframework.mock.web.MockHttpServletRequest;

public class PortResolverImplTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$util$PortResolverImplTests;

    public PortResolverImplTests() {
    }

    public PortResolverImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$util$PortResolverImplTests == null ? (class$org$acegisecurity$util$PortResolverImplTests = PortResolverImplTests.class$("org.acegisecurity.util.PortResolverImplTests")) : class$org$acegisecurity$util$PortResolverImplTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDetectsBuggyIeHttpRequest() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        pr.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServerPort(8443);
        request.setScheme("HTtP");
        PortResolverImplTests.assertEquals((int)8080, (int)pr.getServerPort((ServletRequest)request));
    }

    public void testDetectsBuggyIeHttpsRequest() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        pr.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setServerPort(8080);
        request.setScheme("HTtPs");
        PortResolverImplTests.assertEquals((int)8443, (int)pr.getServerPort((ServletRequest)request));
    }

    public void testDetectsEmptyPortMapper() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        pr.setPortMapper(null);
        try {
            pr.afterPropertiesSet();
            PortResolverImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            PortResolverImplTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        PortResolverImplTests.assertTrue((pr.getPortMapper() != null ? 1 : 0) != 0);
        pr.setPortMapper((PortMapper)new PortMapperImpl());
        PortResolverImplTests.assertTrue((pr.getPortMapper() != null ? 1 : 0) != 0);
    }

    public void testNormalOperation() throws Exception {
        PortResolverImpl pr = new PortResolverImpl();
        pr.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setScheme("http");
        request.setServerPort(1021);
        PortResolverImplTests.assertEquals((int)1021, (int)pr.getServerPort((ServletRequest)request));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

