/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.vote;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthorizationServiceException;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockAclManager;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.AclManager;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.MockAclObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.SimpleMethodInvocation;
import org.acegisecurity.vote.BasicAclEntryVoter;
import org.acegisecurity.vote.SomeDomainObject;
import org.aopalliance.intercept.MethodInvocation;

public class BasicAclEntryVoterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$vote$SomeDomainObjectManager;
    static /* synthetic */ Class class$org$acegisecurity$vote$SomeDomainObject;
    static /* synthetic */ Class class$org$acegisecurity$vote$BasicAclEntryVoterTests;
    static /* synthetic */ Class class$org$aopalliance$intercept$MethodInvocation;
    static /* synthetic */ Class class$org$aspectj$lang$JoinPoint;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public BasicAclEntryVoterTests() {
    }

    public BasicAclEntryVoterTests(String arg0) {
        super(arg0);
    }

    private MethodInvocation getMethodInvocation(SomeDomainObject domainObject) throws Exception {
        Class clazz = class$org$acegisecurity$vote$SomeDomainObjectManager == null ? (class$org$acegisecurity$vote$SomeDomainObjectManager = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObjectManager")) : class$org$acegisecurity$vote$SomeDomainObjectManager;
        Method method = clazz.getMethod("someServiceMethod", class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        return new SimpleMethodInvocation(method, new Object[]{domainObject});
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$vote$BasicAclEntryVoterTests == null ? (class$org$acegisecurity$vote$BasicAclEntryVoterTests = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.BasicAclEntryVoterTests")) : class$org$acegisecurity$vote$BasicAclEntryVoterTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testNormalOperation() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        BasicAclEntryVoterTests.assertEquals((Object)aclManager, (Object)voter.getAclManager());
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        BasicAclEntryVoterTests.assertEquals((String)"FOO_ADMIN_OR_WRITE_ACCESS", (String)voter.getProcessConfigAttribute());
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        BasicAclEntryVoterTests.assertEquals((int)2, (int)voter.getRequirePermission().length);
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        BasicAclEntryVoterTests.assertEquals((Object)(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject), (Object)voter.getProcessDomainObjectClass());
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr));
    }

    public void testOnlySupportsMethodInvocationAndJoinPoint() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports(class$org$aopalliance$intercept$MethodInvocation == null ? (class$org$aopalliance$intercept$MethodInvocation = BasicAclEntryVoterTests.class$("org.aopalliance.intercept.MethodInvocation")) : class$org$aopalliance$intercept$MethodInvocation));
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports(class$org$aspectj$lang$JoinPoint == null ? (class$org$aspectj$lang$JoinPoint = BasicAclEntryVoterTests.class$("org.aspectj.lang.JoinPoint")) : class$org$aspectj$lang$JoinPoint));
        BasicAclEntryVoterTests.assertFalse((boolean)voter.supports(class$java$lang$String == null ? (class$java$lang$String = BasicAclEntryVoterTests.class$("java.lang.String")) : class$java$lang$String));
    }

    public void testStartupRejectsMissingAclManager() throws Exception {
        MockAclManager aclManager = new MockAclManager("domain1", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingProcessConfigAttribute() throws Exception {
        MockAclManager aclManager = new MockAclManager("domain1", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingProcessDomainObjectClass() throws Exception {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        try {
            voter.setProcessDomainObjectClass(null);
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testStartupRejectsMissingRequirePermission() throws Exception {
        MockAclManager aclManager = new MockAclManager("domain1", "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        try {
            voter.afterPropertiesSet();
            BasicAclEntryVoterTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSupportsConfigAttribute() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setProcessConfigAttribute("foobar");
        BasicAclEntryVoterTests.assertTrue((boolean)voter.supports((ConfigAttribute)new SecurityConfig("foobar")));
    }

    public void testVoterAbstainsIfDomainObjectIsNull() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("A_DIFFERENT_ATTRIBUTE"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)0, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr));
    }

    public void testVoterAbstainsIfNotMatchingConfigAttribute() throws Exception {
        SomeDomainObject domainObject = null;
        MockAclManager aclManager = new MockAclManager(domainObject, "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)0, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr));
    }

    public void testVoterCanDenyAccessBasedOnInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.setInternalMethod("getParent");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)-1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr));
    }

    public void testVoterCanDenyAccessIfPrincipalHasNoPermissionsAtAllToDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject, "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.setInternalMethod("getParent");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)-1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"scott", null), (Object)mi, attr));
    }

    public void testVoterCanGrantAccessBasedOnInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.setInternalMethod("getParent");
        BasicAclEntryVoterTests.assertEquals((String)"getParent", (String)voter.getInternalMethod());
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        BasicAclEntryVoterTests.assertEquals((int)1, (int)voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr));
    }

    public void testVoterThrowsExceptionIfInvalidInternalMethodOfDomainObject() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.setInternalMethod("getNonExistentParentName");
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        MethodInvocation mi = this.getMethodInvocation(domainObject);
        try {
            voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr);
            BasicAclEntryVoterTests.fail((String)"Should have thrown AuthorizationServiceException");
        }
        catch (AuthorizationServiceException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testVoterThrowsExceptionIfProcessDomainObjectNotFound() throws Exception {
        SomeDomainObject domainObject = new SomeDomainObject("foo");
        MockAclManager aclManager = new MockAclManager(domainObject.getParent(), "marissa", new AclEntry[]{new MockAclEntry(), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.ADMINISTRATION), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.READ), new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)new MockAclObjectIdentity(), null, SimpleAclEntry.DELETE)});
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setAclManager((AclManager)aclManager);
        voter.setProcessConfigAttribute("FOO_ADMIN_OR_WRITE_ACCESS");
        voter.setRequirePermission(new int[]{SimpleAclEntry.ADMINISTRATION, SimpleAclEntry.WRITE});
        voter.setProcessDomainObjectClass(class$org$acegisecurity$vote$SomeDomainObject == null ? (class$org$acegisecurity$vote$SomeDomainObject = BasicAclEntryVoterTests.class$("org.acegisecurity.vote.SomeDomainObject")) : class$org$acegisecurity$vote$SomeDomainObject);
        voter.afterPropertiesSet();
        ConfigAttributeDefinition attr = new ConfigAttributeDefinition();
        attr.addConfigAttribute((ConfigAttribute)new SecurityConfig("FOO_ADMIN_OR_WRITE_ACCESS"));
        Class clazz = class$java$lang$String == null ? (class$java$lang$String = BasicAclEntryVoterTests.class$("java.lang.String")) : class$java$lang$String;
        Method method = clazz.getMethod("toString", new Class[0]);
        SimpleMethodInvocation mi = new SimpleMethodInvocation(method, new Object[]{domainObject});
        try {
            voter.vote((Authentication)new UsernamePasswordAuthenticationToken((Object)"marissa", null), (Object)mi, attr);
            BasicAclEntryVoterTests.fail((String)"Should have thrown AuthorizationServiceException");
        }
        catch (AuthorizationServiceException expected) {
            BasicAclEntryVoterTests.assertTrue((boolean)true);
        }
    }

    public void testSetRequirePermissionFromString() {
        this.assertPermission("NOTHING", 0);
        this.assertPermission("ADMINISTRATION", SimpleAclEntry.ADMINISTRATION);
        this.assertPermission("READ", SimpleAclEntry.READ);
        this.assertPermission("WRITE", SimpleAclEntry.WRITE);
        this.assertPermission("CREATE", SimpleAclEntry.CREATE);
        this.assertPermission("DELETE", SimpleAclEntry.DELETE);
        this.assertPermission(new String[]{"WRITE", "CREATE"}, new int[]{SimpleAclEntry.WRITE, SimpleAclEntry.CREATE});
    }

    public void testSetRequirePermissionFromStringWrongValues() {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        try {
            voter.setRequirePermissionFromString(new String[]{"X"});
            BasicAclEntryVoterTests.fail((String)((class$java$lang$IllegalArgumentException == null ? (class$java$lang$IllegalArgumentException = BasicAclEntryVoterTests.class$("java.lang.IllegalArgumentException")) : class$java$lang$IllegalArgumentException).getName() + " must have been thrown."));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void assertPermission(String text, int value) {
        this.assertPermission(new String[]{text}, new int[]{value});
    }

    private void assertPermission(String[] text, int[] value) {
        BasicAclEntryVoter voter = new BasicAclEntryVoter();
        voter.setRequirePermissionFromString(text);
        BasicAclEntryVoterTests.assertEquals((String)"Test incorreclty coded", (int)value.length, (int)text.length);
        BasicAclEntryVoterTests.assertEquals((int)value.length, (int)voter.getRequirePermission().length);
        for (int i = 0; i < value.length; ++i) {
            BasicAclEntryVoterTests.assertEquals((int)value[i], (int)voter.getRequirePermission()[i]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAclEntry
    implements AclEntry {
        private MockAclEntry() {
        }
    }
}

