/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.wrapper;

import javax.servlet.http.HttpServletRequest;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.TestingAuthenticationToken;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.acegisecurity.wrapper.SecurityContextHolderAwareRequestWrapper;
import org.springframework.mock.web.MockHttpServletRequest;

public class SecurityContextHolderAwareRequestWrapperTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$wrapper$SecurityContextHolderAwareRequestWrapperTests;

    public SecurityContextHolderAwareRequestWrapperTests() {
    }

    public SecurityContextHolderAwareRequestWrapperTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$wrapper$SecurityContextHolderAwareRequestWrapperTests == null ? (class$org$acegisecurity$wrapper$SecurityContextHolderAwareRequestWrapperTests = SecurityContextHolderAwareRequestWrapperTests.class$("org.acegisecurity.wrapper.SecurityContextHolderAwareRequestWrapperTests")) : class$org$acegisecurity$wrapper$SecurityContextHolderAwareRequestWrapperTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCorrectOperationWithStringBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)"marissa", (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_FOO")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"marissa", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)auth, (Object)wrapper.getUserPrincipal());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testCorrectOperationWithUserDetailsBasedPrincipal() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken((Object)new User("marissaAsUserDetails", "koala", true, true, true, true, new GrantedAuthority[0]), (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_HELLO"), new GrantedAuthorityImpl("ROLE_FOOBAR")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((String)"marissaAsUserDetails", (String)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_NOT_GRANTED"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertTrue((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertEquals((Object)auth, (Object)wrapper.getUserPrincipal());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testNullAuthenticationHandling() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_ANY"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    public void testNullPrincipalHandling() throws Exception {
        TestingAuthenticationToken auth = new TestingAuthenticationToken(null, (Object)"koala", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_HELLO"), new GrantedAuthorityImpl("ROLE_FOOBAR")});
        SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/");
        SecurityContextHolderAwareRequestWrapper wrapper = new SecurityContextHolderAwareRequestWrapper((HttpServletRequest)request, (PortResolver)new PortResolverImpl());
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getRemoteUser());
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_HELLO"));
        SecurityContextHolderAwareRequestWrapperTests.assertFalse((boolean)wrapper.isUserInRole("ROLE_FOOBAR"));
        SecurityContextHolderAwareRequestWrapperTests.assertNull((Object)wrapper.getUserPrincipal());
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

