/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.acl.AclEntry;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolver;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.userdetails.User;

public class GrantedAuthorityEffectiveAclsResolverTests
extends TestCase {
    private SimpleAclEntry entry100RoleEverybody = new SimpleAclEntry((Object)"ROLE_EVERYBODY", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 14);
    private SimpleAclEntry entry100RoleOne = new SimpleAclEntry((Object)"ROLE_ONE", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 0);
    private SimpleAclEntry entry100RoleTwo = new SimpleAclEntry((Object)"ROLE_TWO", (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
    private UsernamePasswordAuthenticationToken scott = new UsernamePasswordAuthenticationToken((Object)"scott", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_TWO")});
    private SimpleAclEntry entry100Scott = new SimpleAclEntry(this.scott.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 4);
    private UsernamePasswordAuthenticationToken dianne = new UsernamePasswordAuthenticationToken((Object)"dianne", (Object)"not used");
    private UsernamePasswordAuthenticationToken marissa = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_ONE")});
    private SimpleAclEntry entry100Marissa = new SimpleAclEntry(this.marissa.getPrincipal(), (AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"), null, 2);
    private UsernamePasswordAuthenticationToken scottWithUserDetails = new UsernamePasswordAuthenticationToken((Object)new User("scott", "NOT_USED", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY")}), (Object)"not used", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_EVERYBODY"), new GrantedAuthorityImpl("ROLE_TWO")});
    private SimpleAclEntry[] acls = new SimpleAclEntry[]{this.entry100Marissa, this.entry100Scott, this.entry100RoleEverybody, this.entry100RoleOne, this.entry100RoleTwo};
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolverTests;

    public GrantedAuthorityEffectiveAclsResolverTests() {
    }

    public GrantedAuthorityEffectiveAclsResolverTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolverTests == null ? (class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolverTests = GrantedAuthorityEffectiveAclsResolverTests.class$("org.acegisecurity.acl.basic.GrantedAuthorityEffectiveAclsResolverTests")) : class$org$acegisecurity$acl$basic$GrantedAuthorityEffectiveAclsResolverTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testResolveAclsForDianneWhoHasANullForAuthorities() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertNull((Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.dianne));
    }

    public void testResolveAclsForMarissa() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.marissa).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100Marissa, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.marissa)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.marissa)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleOne, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.marissa)[2]);
    }

    public void testResolveAclsForScottWithStringObjectAsPrincipal() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100Scott, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleTwo, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scott)[2]);
    }

    public void testResolveAclsForScottWithUserDetailsObjectAsPrincipal() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails).length);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100Scott, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[0]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleEverybody, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[1]);
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((Object)this.entry100RoleTwo, (Object)resolver.resolveEffectiveAcls((AclEntry[])this.acls, (Authentication)this.scottWithUserDetails)[2]);
    }

    public void testResolveAclsReturnsNullIfNoAclsInFirstPlace() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        GrantedAuthorityEffectiveAclsResolverTests.assertNull((Object)resolver.resolveEffectiveAcls(null, (Authentication)this.scott));
    }

    public void testSkipsNonBasicAclEntryObjects() {
        GrantedAuthorityEffectiveAclsResolver resolver = new GrantedAuthorityEffectiveAclsResolver();
        AclEntry[] basicAcls = new AclEntry[]{this.entry100Marissa, this.entry100Scott, this.entry100RoleEverybody, this.entry100RoleOne, new MockAcl(), this.entry100RoleTwo};
        GrantedAuthorityEffectiveAclsResolverTests.assertEquals((int)3, (int)resolver.resolveEffectiveAcls(basicAcls, (Authentication)this.marissa).length);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockAcl
    implements AclEntry {
        private MockAcl() {
        }
    }
}

