/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.cache;

import junit.framework.TestCase;
import net.sf.ehcache.Ehcache;
import org.acegisecurity.MockApplicationContext;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.acl.basic.cache.EhCacheBasedAclEntryCache;
import org.springframework.context.ConfigurableApplicationContext;

public class EhCacheBasedAclEntryCacheTests
extends TestCase {
    private static final AclObjectIdentity OBJECT_100 = new NamedEntityObjectIdentity("OBJECT", "100");
    private static final AclObjectIdentity OBJECT_200 = new NamedEntityObjectIdentity("OBJECT", "200");
    private static final BasicAclEntry OBJECT_100_MARISSA = new SimpleAclEntry((Object)"marissa", OBJECT_100, null, 2);
    private static final BasicAclEntry OBJECT_100_SCOTT = new SimpleAclEntry((Object)"scott", OBJECT_100, null, 4);
    private static final BasicAclEntry OBJECT_200_PETER = new SimpleAclEntry((Object)"peter", OBJECT_200, null, 4);

    public EhCacheBasedAclEntryCacheTests() {
    }

    public EhCacheBasedAclEntryCacheTests(String arg0) {
        super(arg0);
    }

    private Ehcache getCache() {
        ConfigurableApplicationContext ctx = MockApplicationContext.getContext();
        return (Ehcache)ctx.getBean("eHCacheBackend");
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testCacheOperation() throws Exception {
        EhCacheBasedAclEntryCache cache = new EhCacheBasedAclEntryCache();
        cache.setCache(this.getCache());
        cache.afterPropertiesSet();
        cache.putEntriesInCache(new BasicAclEntry[]{OBJECT_100_SCOTT, OBJECT_100_MARISSA});
        cache.putEntriesInCache(new BasicAclEntry[]{OBJECT_200_PETER});
        EhCacheBasedAclEntryCacheTests.assertEquals((Object)OBJECT_100_SCOTT, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"))[0]);
        EhCacheBasedAclEntryCacheTests.assertEquals((Object)OBJECT_100_MARISSA, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"))[1]);
        EhCacheBasedAclEntryCacheTests.assertEquals((Object)OBJECT_200_PETER, (Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "200"))[0]);
        EhCacheBasedAclEntryCacheTests.assertNull((Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "NOT_IN_CACHE")));
        cache.removeEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100"));
        EhCacheBasedAclEntryCacheTests.assertNull((Object)cache.getEntriesFromCache((AclObjectIdentity)new NamedEntityObjectIdentity("OBJECT", "100")));
    }

    public void testStartupDetectsMissingCache() throws Exception {
        EhCacheBasedAclEntryCache cache = new EhCacheBasedAclEntryCache();
        try {
            cache.afterPropertiesSet();
            EhCacheBasedAclEntryCacheTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            EhCacheBasedAclEntryCacheTests.assertTrue((boolean)true);
        }
        Ehcache myCache = this.getCache();
        cache.setCache(myCache);
        EhCacheBasedAclEntryCacheTests.assertEquals((Object)myCache, (Object)cache.getCache());
    }
}

