/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.PopulatedDatabase;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.jdbc.JdbcDaoImpl;
import org.springframework.jdbc.object.MappingSqlQuery;

public class JdbcDaoImplTests
extends TestCase {
    public static final String OBJECT_IDENTITY = "org.acegisecurity.acl.DomainObject";
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImplTests;

    public JdbcDaoImplTests() {
    }

    public JdbcDaoImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImplTests == null ? (class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImplTests = JdbcDaoImplTests.class$("org.acegisecurity.acl.basic.jdbc.JdbcDaoImplTests")) : class$org$acegisecurity$acl$basic$jdbc$JdbcDaoImplTests));
    }

    private JdbcDaoImpl makePopulatedJdbcDao() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.afterPropertiesSet();
        return dao;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testExceptionThrownIfBasicAclEntryClassNotFound() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "7");
        try {
            dao.getAcls((AclObjectIdentity)identity);
            JdbcDaoImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testGetsEntriesWhichExistInDatabaseAndHaveAcls() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "2");
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcDaoImplTests.assertEquals((int)2, (int)acls.length);
    }

    public void testGetsEntriesWhichExistInDatabaseButHaveNoAcls() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "5");
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcDaoImplTests.assertEquals((int)1, (int)acls.length);
        JdbcDaoImplTests.assertEquals((Object)"___INHERITENCE_MARKER_ONLY___", (Object)acls[0].getRecipient());
    }

    public void testGetsEntriesWhichHaveNoParent() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcDaoImplTests.assertEquals((int)1, (int)acls.length);
        JdbcDaoImplTests.assertNull((Object)acls[0].getAclObjectParentIdentity());
    }

    public void testGettersSetters() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        dao.setAclsByObjectIdentity((MappingSqlQuery)new MockMappingSqlQuery());
        JdbcDaoImplTests.assertNotNull((Object)dao.getAclsByObjectIdentity());
        dao.setAclsByObjectIdentityQuery("foo");
        JdbcDaoImplTests.assertEquals((String)"foo", (String)dao.getAclsByObjectIdentityQuery());
        dao.setObjectPropertiesQuery("foobar");
        JdbcDaoImplTests.assertEquals((String)"foobar", (String)dao.getObjectPropertiesQuery());
    }

    public void testNullReturnedIfEntityNotFound() throws Exception {
        JdbcDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "NOT_VALID_ID");
        BasicAclEntry[] result = dao.getAcls((AclObjectIdentity)identity);
        JdbcDaoImplTests.assertNull((Object)result);
    }

    public void testReturnsNullForUnNamedEntityObjectIdentity() throws Exception {
        JdbcDaoImpl dao = new JdbcDaoImpl();
        AclObjectIdentity identity = new AclObjectIdentity(){};
        JdbcDaoImplTests.assertNull((Object)dao.getAcls(identity));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockMappingSqlQuery
    extends MappingSqlQuery {
        private MockMappingSqlQuery() {
        }

        protected Object mapRow(ResultSet arg0, int arg1) throws SQLException {
            return null;
        }
    }
}

