/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acl.basic.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.PopulatedDatabase;
import org.acegisecurity.acl.basic.AclObjectIdentity;
import org.acegisecurity.acl.basic.BasicAclEntry;
import org.acegisecurity.acl.basic.NamedEntityObjectIdentity;
import org.acegisecurity.acl.basic.SimpleAclEntry;
import org.acegisecurity.acl.basic.jdbc.JdbcExtendedDaoImpl;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.jdbc.object.MappingSqlQuery;

public class JdbcExtendedDaoImplTests
extends TestCase {
    public static final String OBJECT_IDENTITY = "org.acegisecurity.acl.DomainObject";
    static /* synthetic */ Class class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImplTests;

    public JdbcExtendedDaoImplTests() {
    }

    public JdbcExtendedDaoImplTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImplTests == null ? (class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImplTests = JdbcExtendedDaoImplTests.class$("org.acegisecurity.acl.basic.jdbc.JdbcExtendedDaoImplTests")) : class$org$acegisecurity$acl$basic$jdbc$JdbcExtendedDaoImplTests));
    }

    private JdbcExtendedDaoImpl makePopulatedJdbcDao() throws Exception {
        JdbcExtendedDaoImpl dao = new JdbcExtendedDaoImpl();
        dao.setDataSource(PopulatedDatabase.getDataSource());
        dao.afterPropertiesSet();
        return dao;
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testChangeMask() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "204");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.CREATE);
        dao.create((BasicAclEntry)simpleAcl1);
        SimpleAclEntry simpleAcl2 = new SimpleAclEntry((Object)"scott", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.READ);
        dao.create((BasicAclEntry)simpleAcl2);
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)2, (int)acls.length);
        JdbcExtendedDaoImplTests.assertEquals((int)SimpleAclEntry.CREATE, (int)acls[0].getMask());
        JdbcExtendedDaoImplTests.assertEquals((int)SimpleAclEntry.READ, (int)acls[1].getMask());
        dao.changeMask((AclObjectIdentity)identity, (Object)"marissa", new Integer(SimpleAclEntry.ADMINISTRATION));
        dao.changeMask((AclObjectIdentity)identity, (Object)"scott", new Integer(0));
        acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)2, (int)acls.length);
        JdbcExtendedDaoImplTests.assertEquals((Object)"marissa", (Object)acls[0].getRecipient());
        JdbcExtendedDaoImplTests.assertEquals((int)SimpleAclEntry.ADMINISTRATION, (int)acls[0].getMask());
        JdbcExtendedDaoImplTests.assertEquals((Object)"scott", (Object)acls[1].getRecipient());
        JdbcExtendedDaoImplTests.assertEquals((int)0, (int)acls[1].getMask());
    }

    public void testChangeMaskThrowsExceptionWhenExistingRecordNotFound() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "205");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.CREATE);
        dao.create((BasicAclEntry)simpleAcl1);
        try {
            dao.changeMask((AclObjectIdentity)identity, (Object)"scott", new Integer(SimpleAclEntry.ADMINISTRATION));
            JdbcExtendedDaoImplTests.fail((String)"Should have thrown DataRetrievalFailureException");
        }
        catch (DataRetrievalFailureException expected) {
            JdbcExtendedDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testConvertAclObjectIdentity() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        try {
            dao.convertAclObjectIdentityToString(new AclObjectIdentity(){});
            JdbcExtendedDaoImplTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            JdbcExtendedDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testCreationOfIdentityThenAclInSeparateInvocations() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "206");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry();
        simpleAcl1.setAclObjectIdentity((AclObjectIdentity)identity);
        simpleAcl1.setAclObjectParentIdentity((AclObjectIdentity)parentIdentity);
        dao.create((BasicAclEntry)simpleAcl1);
        dao.delete((AclObjectIdentity)identity);
    }

    public void testDeletionOfAllRecipients() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "203");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, null, SimpleAclEntry.CREATE);
        dao.create((BasicAclEntry)simpleAcl1);
        SimpleAclEntry simpleAcl2 = new SimpleAclEntry((Object)"scott", (AclObjectIdentity)identity, null, SimpleAclEntry.READ);
        dao.create((BasicAclEntry)simpleAcl2);
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)2, (int)acls.length);
        dao.delete((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAcls((AclObjectIdentity)identity));
    }

    public void testDeletionOfSpecificRecipient() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "202");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.CREATE);
        dao.create((BasicAclEntry)simpleAcl1);
        SimpleAclEntry simpleAcl2 = new SimpleAclEntry((Object)"scott", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.READ);
        dao.create((BasicAclEntry)simpleAcl2);
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)2, (int)acls.length);
        dao.delete((AclObjectIdentity)identity, (Object)"scott");
        acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)1, (int)acls.length);
        JdbcExtendedDaoImplTests.assertEquals((Object)simpleAcl1.getRecipient(), (Object)acls[0].getRecipient());
    }

    public void testGettersSetters() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclObjectIdentityDelete());
        dao.setAclObjectIdentityDelete(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclObjectIdentityDelete());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclObjectIdentityInsert());
        dao.setAclObjectIdentityInsert(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclObjectIdentityInsert());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionDelete());
        dao.setAclPermissionDelete(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclPermissionDelete());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionInsert());
        dao.setAclPermissionInsert(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclPermissionInsert());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionUpdate());
        dao.setAclPermissionUpdate(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclPermissionUpdate());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclsByObjectIdentity());
        dao.setAclsByObjectIdentity(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getAclsByObjectIdentity());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getLookupPermissionIdMapping());
        dao.setLookupPermissionIdMapping(null);
        JdbcExtendedDaoImplTests.assertNull((Object)dao.getLookupPermissionIdMapping());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclObjectIdentityDeleteStatement());
        dao.setAclObjectIdentityDeleteStatement("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclObjectIdentityDeleteStatement());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclObjectIdentityInsertStatement());
        dao.setAclObjectIdentityInsertStatement("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclObjectIdentityInsertStatement());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionDeleteStatement());
        dao.setAclPermissionDeleteStatement("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclPermissionDeleteStatement());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionInsertStatement());
        dao.setAclPermissionInsertStatement("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclPermissionInsertStatement());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclPermissionUpdateStatement());
        dao.setAclPermissionUpdateStatement("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclPermissionUpdateStatement());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getAclsByObjectIdentityQuery());
        dao.setAclsByObjectIdentityQuery("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getAclsByObjectIdentityQuery());
        JdbcExtendedDaoImplTests.assertNotNull((Object)dao.getLookupPermissionIdQuery());
        dao.setLookupPermissionIdQuery("SELECT ...");
        JdbcExtendedDaoImplTests.assertEquals((String)"SELECT ...", (String)dao.getLookupPermissionIdQuery());
    }

    public void testNormalCreationAndDuplicateDetection() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "200");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "1");
        SimpleAclEntry simpleAcl1 = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.CREATE);
        dao.create((BasicAclEntry)simpleAcl1);
        SimpleAclEntry simpleAcl2 = new SimpleAclEntry((Object)"scott", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.READ);
        dao.create((BasicAclEntry)simpleAcl2);
        BasicAclEntry[] acls = dao.getAcls((AclObjectIdentity)identity);
        JdbcExtendedDaoImplTests.assertEquals((int)2, (int)acls.length);
        JdbcExtendedDaoImplTests.assertEquals((Object)simpleAcl1.getRecipient(), (Object)acls[0].getRecipient());
        JdbcExtendedDaoImplTests.assertEquals((int)simpleAcl1.getMask(), (int)acls[0].getMask());
        JdbcExtendedDaoImplTests.assertEquals((Object)simpleAcl2.getRecipient(), (Object)acls[1].getRecipient());
        JdbcExtendedDaoImplTests.assertEquals((int)simpleAcl2.getMask(), (int)acls[1].getMask());
        try {
            dao.create((BasicAclEntry)simpleAcl1);
            JdbcExtendedDaoImplTests.fail((String)"Should have thrown DataIntegrityViolationException");
        }
        catch (DataIntegrityViolationException expected) {
            JdbcExtendedDaoImplTests.assertTrue((boolean)true);
        }
    }

    public void testRejectsInvalidParent() throws Exception {
        JdbcExtendedDaoImpl dao = this.makePopulatedJdbcDao();
        NamedEntityObjectIdentity identity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "201");
        NamedEntityObjectIdentity parentIdentity = new NamedEntityObjectIdentity(OBJECT_IDENTITY, "987987987987986");
        SimpleAclEntry simpleAcl = new SimpleAclEntry((Object)"marissa", (AclObjectIdentity)identity, (AclObjectIdentity)parentIdentity, SimpleAclEntry.CREATE);
        try {
            dao.create((BasicAclEntry)simpleAcl);
            JdbcExtendedDaoImplTests.fail((String)"Should have thrown DataRetrievalFailureException");
        }
        catch (DataRetrievalFailureException expected) {
            JdbcExtendedDaoImplTests.assertTrue((boolean)true);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockMappingSqlQuery
    extends MappingSqlQuery {
        private MockMappingSqlQuery() {
        }

        protected Object mapRow(ResultSet arg0, int arg1) throws SQLException {
            return null;
        }
    }
}

