/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.acls.domain;

import junit.framework.TestCase;
import org.acegisecurity.acls.Permission;
import org.acegisecurity.acls.domain.BasePermission;
import org.acegisecurity.acls.domain.CumulativePermission;

public class PermissionTests
extends TestCase {
    public void testExpectedIntegerValues() {
        PermissionTests.assertEquals((int)1, (int)BasePermission.READ.getMask());
        PermissionTests.assertEquals((int)16, (int)BasePermission.ADMINISTRATION.getMask());
        PermissionTests.assertEquals((int)7, (int)new CumulativePermission().set(BasePermission.READ).set(BasePermission.WRITE).set(BasePermission.CREATE).getMask());
        PermissionTests.assertEquals((int)17, (int)new CumulativePermission().set(BasePermission.READ).set(BasePermission.ADMINISTRATION).getMask());
    }

    public void testFromInteger() {
        Permission permission = BasePermission.buildFromMask((int)7);
        System.out.println("7 =  " + permission.toString());
        permission = BasePermission.buildFromMask((int)4);
        System.out.println("4 =  " + permission.toString());
    }

    public void testStringConversion() {
        System.out.println("R =  " + BasePermission.READ.toString());
        PermissionTests.assertEquals((String)"BasePermission[...............................R=1]", (String)BasePermission.READ.toString());
        System.out.println("A =  " + BasePermission.ADMINISTRATION.toString());
        PermissionTests.assertEquals((String)"BasePermission[...........................A....=16]", (String)BasePermission.ADMINISTRATION.toString());
        System.out.println("R =  " + new CumulativePermission().set(BasePermission.READ).toString());
        PermissionTests.assertEquals((String)"CumulativePermission[...............................R=1]", (String)new CumulativePermission().set(BasePermission.READ).toString());
        System.out.println("A =  " + new CumulativePermission().set(BasePermission.ADMINISTRATION).toString());
        PermissionTests.assertEquals((String)"CumulativePermission[...........................A....=16]", (String)new CumulativePermission().set(BasePermission.ADMINISTRATION).toString());
        System.out.println("RA = " + new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).toString());
        PermissionTests.assertEquals((String)"CumulativePermission[...........................A...R=17]", (String)new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).toString());
        System.out.println("R =  " + new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).clear(BasePermission.ADMINISTRATION).toString());
        PermissionTests.assertEquals((String)"CumulativePermission[...............................R=1]", (String)new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).clear(BasePermission.ADMINISTRATION).toString());
        System.out.println("0 =  " + new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).clear(BasePermission.ADMINISTRATION).clear(BasePermission.READ).toString());
        PermissionTests.assertEquals((String)"CumulativePermission[................................=0]", (String)new CumulativePermission().set(BasePermission.ADMINISTRATION).set(BasePermission.READ).clear(BasePermission.ADMINISTRATION).clear(BasePermission.READ).toString());
    }
}

