/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.adapters;

import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.adapters.AbstractAdapterAuthenticationToken;

public class AbstractAdapterAuthenticationTokenTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$adapters$AbstractAdapterAuthenticationTokenTests;

    public AbstractAdapterAuthenticationTokenTests() {
    }

    public AbstractAdapterAuthenticationTokenTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$adapters$AbstractAdapterAuthenticationTokenTests == null ? (class$org$acegisecurity$adapters$AbstractAdapterAuthenticationTokenTests = AbstractAdapterAuthenticationTokenTests.class$("org.acegisecurity.adapters.AbstractAdapterAuthenticationTokenTests")) : class$org$acegisecurity$adapters$AbstractAdapterAuthenticationTokenTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testGetters() throws Exception {
        MockDecisionManagerImpl token = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertEquals((Object)"Test", (Object)token.getPrincipal());
        AbstractAdapterAuthenticationTokenTests.assertEquals((Object)"Password", (Object)token.getCredentials());
        AbstractAdapterAuthenticationTokenTests.assertEquals((int)"my_password".hashCode(), (int)token.getKeyHash());
    }

    public void testIsUserInRole() throws Exception {
        MockDecisionManagerImpl token = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((boolean)token.isUserInRole("ROLE_ONE"));
        AbstractAdapterAuthenticationTokenTests.assertTrue((boolean)token.isUserInRole("ROLE_TWO"));
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token.isUserInRole("") ? 1 : 0) != 0);
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token.isUserInRole("ROLE_ONE ") ? 1 : 0) != 0);
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token.isUserInRole("role_one") ? 1 : 0) != 0);
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token.isUserInRole("ROLE_XXXX") ? 1 : 0) != 0);
    }

    public void testObjectsEquals() throws Exception {
        MockDecisionManagerImpl token1 = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        MockDecisionManagerImpl token2 = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertEquals((Object)((Object)token1), (Object)((Object)token2));
        MockDecisionManagerImpl token3 = new MockDecisionManagerImpl("my_password", "Test", "Password_Changed", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals((Object)token3) ? 1 : 0) != 0);
        MockDecisionManagerImpl token4 = new MockDecisionManagerImpl("my_password", "Test_Changed", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals((Object)token4) ? 1 : 0) != 0);
        MockDecisionManagerImpl token5 = new MockDecisionManagerImpl("password_changed", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals((Object)token5) ? 1 : 0) != 0);
        MockDecisionManagerImpl token6 = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO_CHANGED")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals((Object)token6) ? 1 : 0) != 0);
        MockDecisionManagerImpl token7 = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals((Object)token7) ? 1 : 0) != 0);
        AbstractAdapterAuthenticationTokenTests.assertTrue((!token1.equals(new Integer(100)) ? 1 : 0) != 0);
    }

    public void testSetAuthenticatedAlwaysReturnsTrue() throws Exception {
        MockDecisionManagerImpl token = new MockDecisionManagerImpl("my_password", "Test", "Password", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ONE"), new GrantedAuthorityImpl("ROLE_TWO")});
        AbstractAdapterAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
        token.setAuthenticated(false);
        AbstractAdapterAuthenticationTokenTests.assertTrue((boolean)token.isAuthenticated());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockDecisionManagerImpl
    extends AbstractAdapterAuthenticationToken {
        private String password;
        private String username;

        public MockDecisionManagerImpl(String key, String username, String password, GrantedAuthority[] authorities) {
            super(key, authorities);
            this.username = username;
            this.password = password;
        }

        public Object getCredentials() {
            return this.password;
        }

        public Object getPrincipal() {
            return this.username;
        }
    }
}

