/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.captcha;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.captcha.CaptchaChannelProcessorTemplate;
import org.acegisecurity.captcha.CaptchaEntryPoint;
import org.acegisecurity.captcha.CaptchaSecurityContext;
import org.acegisecurity.captcha.CaptchaSecurityContextImpl;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.securechannel.ChannelEntryPoint;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class CaptchaChannelProcessorTemplateTests
extends TestCase {
    private MockHttpServletResponse decideWithNewResponse(ConfigAttributeDefinition cad, CaptchaChannelProcessorTemplate processor, MockHttpServletRequest request) throws IOException, ServletException {
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        processor.decide(fi, cad);
        return response;
    }

    public void setUp() {
        SecurityContextHolder.clearContext();
    }

    public void tearDown() {
        SecurityContextHolder.clearContext();
    }

    public void testContextRedirect() throws Exception {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setKeyword("X");
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new SecurityConfig("Y"));
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        SecurityContextHolder.setContext((SecurityContext)context);
        CaptchaEntryPoint epoint = new CaptchaEntryPoint();
        epoint.setCaptchaFormUrl("/jcaptcha.do");
        epoint.setIncludeOriginalRequest(false);
        processor.setEntryPoint((ChannelEntryPoint)epoint);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/demo");
        request.setServletPath("/restricted");
        request.setScheme("http");
        request.setServerPort(8000);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        processor.decide(fi, cad);
        CaptchaChannelProcessorTemplateTests.assertEquals(null, (String)response.getRedirectedUrl());
        processor.setKeyword("Y");
        response = this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals((String)"http://localhost:8000/demo/jcaptcha.do", (String)response.getRedirectedUrl());
        context.setHuman();
        response = this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals(null, (String)response.getRedirectedUrl());
    }

    public void testDecideRejectsNulls() throws Exception {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setEntryPoint((ChannelEntryPoint)new CaptchaEntryPoint());
        processor.setKeyword("X");
        processor.afterPropertiesSet();
        try {
            processor.decide(null, null);
            CaptchaChannelProcessorTemplateTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CaptchaChannelProcessorTemplateTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        CaptchaChannelProcessorTemplateTests.assertEquals(null, (String)processor.getKeyword());
        processor.setKeyword("X");
        CaptchaChannelProcessorTemplateTests.assertEquals((String)"X", (String)processor.getKeyword());
        CaptchaChannelProcessorTemplateTests.assertEquals((int)0, (int)processor.getThresold());
        processor.setThresold(1);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)1, (int)processor.getThresold());
        CaptchaChannelProcessorTemplateTests.assertTrue((processor.getEntryPoint() == null ? 1 : 0) != 0);
        processor.setEntryPoint((ChannelEntryPoint)new CaptchaEntryPoint());
        CaptchaChannelProcessorTemplateTests.assertTrue((processor.getEntryPoint() != null ? 1 : 0) != 0);
    }

    public void testIncrementRequestCount() throws Exception {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setKeyword("X");
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition();
        cad.addConfigAttribute((ConfigAttribute)new SecurityConfig("X"));
        CaptchaSecurityContextImpl context = new CaptchaSecurityContextImpl();
        SecurityContextHolder.setContext((SecurityContext)context);
        CaptchaEntryPoint epoint = new CaptchaEntryPoint();
        epoint.setCaptchaFormUrl("/jcaptcha.do");
        processor.setEntryPoint((ChannelEntryPoint)epoint);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/demo");
        request.setServletPath("/restricted");
        request.setScheme("http");
        request.setServerPort(8000);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        processor.decide(fi, cad);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
        context.setHuman();
        this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)1, (int)context.getHumanRestrictedResourcesRequestsCount());
        this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)2, (int)context.getHumanRestrictedResourcesRequestsCount());
        processor.setKeyword("Y");
        this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)2, (int)context.getHumanRestrictedResourcesRequestsCount());
        context = new CaptchaSecurityContextImpl();
        this.decideWithNewResponse(cad, processor, request);
        CaptchaChannelProcessorTemplateTests.assertEquals((int)0, (int)context.getHumanRestrictedResourcesRequestsCount());
    }

    public void testMissingEntryPoint() throws Exception {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setEntryPoint(null);
        try {
            processor.afterPropertiesSet();
            CaptchaChannelProcessorTemplateTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            CaptchaChannelProcessorTemplateTests.assertEquals((String)"entryPoint required", (String)expected.getMessage());
        }
    }

    public void testMissingKeyword() throws Exception {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setKeyword(null);
        try {
            processor.afterPropertiesSet();
            CaptchaChannelProcessorTemplateTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            // empty catch block
        }
        processor.setKeyword("");
        try {
            processor.afterPropertiesSet();
            CaptchaChannelProcessorTemplateTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSupports() {
        TestHumanityCaptchaChannelProcessor processor = new TestHumanityCaptchaChannelProcessor();
        processor.setKeyword("X");
        CaptchaChannelProcessorTemplateTests.assertTrue((boolean)processor.supports((ConfigAttribute)new SecurityConfig(processor.getKeyword())));
        CaptchaChannelProcessorTemplateTests.assertTrue((boolean)processor.supports((ConfigAttribute)new SecurityConfig("X")));
        CaptchaChannelProcessorTemplateTests.assertFalse((boolean)processor.supports(null));
        CaptchaChannelProcessorTemplateTests.assertFalse((boolean)processor.supports((ConfigAttribute)new SecurityConfig("NOT_SUPPORTED")));
    }

    private class TestHumanityCaptchaChannelProcessor
    extends CaptchaChannelProcessorTemplate {
        private TestHumanityCaptchaChannelProcessor() {
        }

        boolean isContextValidConcerningHumanity(CaptchaSecurityContext context) {
            return context.isHuman();
        }
    }
}

