/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.io.IOException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSession;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.concurrent.ConcurrentSessionFilter;
import org.acegisecurity.concurrent.SessionRegistry;
import org.acegisecurity.concurrent.SessionRegistryImpl;
import org.springframework.mock.web.MockFilterConfig;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockHttpSession;

public class ConcurrentSessionFilterTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$concurrent$ConcurrentSessionFilterTests;

    public ConcurrentSessionFilterTests() {
    }

    public ConcurrentSessionFilterTests(String arg0) {
        super(arg0);
    }

    private void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$concurrent$ConcurrentSessionFilterTests == null ? (class$org$acegisecurity$concurrent$ConcurrentSessionFilterTests = ConcurrentSessionFilterTests.class$("org.acegisecurity.concurrent.ConcurrentSessionFilterTests")) : class$org$acegisecurity$concurrent$ConcurrentSessionFilterTests));
    }

    public void testDetectsExpiredSessions() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(false);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        registry.getSessionInformation(session.getId()).expireNow();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        ConcurrentSessionFilterTests.assertEquals((String)"/expired.jsp", (String)response.getRedirectedUrl());
    }

    public void testDetectsMissingExpiredUrl() throws Exception {
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.setSessionRegistry((SessionRegistry)new SessionRegistryImpl());
        try {
            filter.afterPropertiesSet();
            ConcurrentSessionFilterTests.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException expected) {
            ConcurrentSessionFilterTests.assertTrue((boolean)true);
        }
    }

    public void testDetectsMissingSessionRegistry() throws Exception {
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        filter.setExpiredUrl("xcx");
        try {
            filter.afterPropertiesSet();
            ConcurrentSessionFilterTests.fail((String)"Should have thrown IAE");
        }
        catch (IllegalArgumentException expected) {
            ConcurrentSessionFilterTests.assertTrue((boolean)true);
        }
    }

    public void testUpdatesLastRequestTime() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        request.setSession((HttpSession)session);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterConfig config = new MockFilterConfig(null, null);
        MockFilterChain chain = new MockFilterChain(true);
        ConcurrentSessionFilter filter = new ConcurrentSessionFilter();
        SessionRegistryImpl registry = new SessionRegistryImpl();
        registry.registerNewSession(session.getId(), (Object)"principal");
        Date lastRequest = registry.getSessionInformation(session.getId()).getLastRequest();
        filter.setSessionRegistry((SessionRegistry)registry);
        filter.setExpiredUrl("/expired.jsp");
        Thread.sleep(1000L);
        this.executeFilterInContainerSimulator((FilterConfig)config, (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        ConcurrentSessionFilterTests.assertTrue((boolean)registry.getSessionInformation(session.getId()).getLastRequest().after(lastRequest));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MockFilterChain
    implements FilterChain {
        private boolean expectToProceed;

        public MockFilterChain(boolean expectToProceed) {
            this.expectToProceed = expectToProceed;
        }

        private MockFilterChain() {
        }

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this.expectToProceed) {
                Assert.assertTrue((boolean)true);
            } else {
                Assert.fail((String)"Did not expect filter chain to proceed");
            }
        }
    }
}

