/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.acegisecurity.concurrent.SessionRegistry;
import org.acegisecurity.concurrent.SessionRegistryImpl;

public class SessionRegistryImplMultithreadedTests
extends TestCase {
    private static final Random rnd = new Random();
    private static boolean errorOccurred;

    protected void setUp() throws Exception {
        errorOccurred = false;
    }

    public void testConcurrencyOfReadAndRemoveIsSafe() {
        int i;
        String principal = "Joe Principal";
        SessionRegistryImpl sessionregistry = new SessionRegistryImpl();
        Set<String> sessions = Collections.synchronizedSet(new HashSet());
        for (i = 0; i < 50; ++i) {
            String sessionId = Integer.toString(i);
            sessions.add(sessionId);
            sessionregistry.registerNewSession(sessionId, (Object)principal);
        }
        for (i = 0; i < 10; ++i) {
            Thread reader = new Thread(new SessionRegistryReader(principal, (SessionRegistry)sessionregistry));
            reader.start();
        }
        Thread remover = new Thread(new SessionRemover("remover", (SessionRegistry)sessionregistry, sessions));
        remover.start();
        while (remover.isAlive()) {
            SessionRegistryImplMultithreadedTests.pause(250);
        }
        SessionRegistryImplMultithreadedTests.assertFalse((String)"Thread errors detected; review log output for details", (boolean)errorOccurred);
    }

    public void testConcurrentRemovalIsSafe() {
        String principal = "Some principal object";
        SessionRegistryImpl sessionregistry = new SessionRegistryImpl();
        Set sessions = Collections.synchronizedSet(new HashSet());
        Thread registerer = new Thread(new SessionRegisterer(principal, (SessionRegistry)sessionregistry, 100, sessions));
        registerer.start();
        int nRemovers = 4;
        SessionRemover[] removers = new SessionRemover[nRemovers];
        Thread[] removerThreads = new Thread[nRemovers];
        for (int i = 0; i < removers.length; ++i) {
            removers[i] = new SessionRemover("remover" + i, (SessionRegistry)sessionregistry, sessions);
            removerThreads[i] = new Thread((Runnable)removers[i], "remover" + i);
            removerThreads[i].start();
        }
        while (this.stillRunning(removerThreads)) {
            SessionRegistryImplMultithreadedTests.pause(500);
        }
    }

    private boolean stillRunning(Thread[] threads) {
        for (int i = 0; i < threads.length; ++i) {
            if (!threads[i].isAlive()) continue;
            return true;
        }
        return false;
    }

    private static void pause(int length) {
        try {
            Thread.sleep(length);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static class SessionRemover
    implements Runnable {
        private SessionRegistry sessionregistry;
        private Set sessionList;
        private String name;

        public SessionRemover(String name, SessionRegistry sessionregistry, Set sessionList) {
            this.name = name;
            this.sessionregistry = sessionregistry;
            this.sessionList = sessionList;
        }

        public void run() {
            boolean finished = false;
            while (!finished && !errorOccurred) {
                Object[] sessions;
                if (this.sessionList.isEmpty()) {
                    finished = true;
                    System.out.println(this.name + ": Session list empty. Waiting.");
                    SessionRegistryImplMultithreadedTests.pause(500);
                }
                if ((sessions = this.sessionList.toArray()).length <= 0) continue;
                finished = false;
                String sessionId = (String)sessions[0];
                try {
                    this.sessionregistry.removeSessionInformation(sessionId);
                    SessionRegistryImplMultithreadedTests.pause(rnd.nextInt(100));
                    this.sessionList.remove(sessionId);
                    Thread.yield();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorOccurred = true;
                }
            }
        }
    }

    private static class SessionRegistryReader
    implements Runnable {
        private SessionRegistry sessionRegistry;
        private Object principal;

        public SessionRegistryReader(Object principal, SessionRegistry sessionregistry) {
            this.sessionRegistry = sessionregistry;
            this.principal = principal;
        }

        public void run() {
            while (!errorOccurred) {
                try {
                    this.sessionRegistry.getAllSessions(this.principal, false);
                    this.sessionRegistry.getAllPrincipals();
                    this.sessionRegistry.getAllSessions(this.principal, true);
                    Thread.yield();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorOccurred = true;
                }
            }
        }
    }

    private static class SessionRegisterer
    implements Runnable {
        private SessionRegistry sessionregistry;
        private int nIterations;
        private Set sessionList;
        private Object principal;

        public SessionRegisterer(Object principal, SessionRegistry sessionregistry, int nIterations, Set sessionList) {
            this.sessionregistry = sessionregistry;
            this.nIterations = nIterations;
            this.sessionList = sessionList;
            this.principal = principal;
        }

        public void run() {
            for (int i = 0; i < this.nIterations && !errorOccurred; ++i) {
                String sessionId = Integer.toString(i);
                this.sessionList.add(sessionId);
                try {
                    this.sessionregistry.registerNewSession(sessionId, this.principal);
                    SessionRegistryImplMultithreadedTests.pause(20);
                    Thread.yield();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errorOccurred = true;
                }
            }
        }
    }
}

