/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.concurrent;

import java.util.Date;
import javax.servlet.http.HttpSession;
import junit.framework.TestCase;
import org.acegisecurity.concurrent.SessionInformation;
import org.acegisecurity.concurrent.SessionRegistryImpl;
import org.acegisecurity.ui.session.HttpSessionDestroyedEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.mock.web.MockHttpSession;

public class SessionRegistryImplTests
extends TestCase {
    public void testEventPublishing() {
        MockHttpSession httpSession = new MockHttpSession();
        String principal = "Some principal object";
        String sessionId = httpSession.getId();
        SessionRegistryImplTests.assertNotNull((Object)sessionId);
        SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
        sessionRegistry.registerNewSession(sessionId, (Object)principal);
        sessionRegistry.onApplicationEvent((ApplicationEvent)new HttpSessionDestroyedEvent((HttpSession)httpSession));
        SessionRegistryImplTests.assertNull((Object)sessionRegistry.getSessionInformation(sessionId));
    }

    public void testMultiplePrincipals() throws Exception {
        String principal1 = "principal_1";
        String principal2 = "principal_2";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        String sessionId3 = "5432109876";
        SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
        sessionRegistry.registerNewSession(sessionId1, (Object)principal1);
        sessionRegistry.registerNewSession(sessionId2, (Object)principal1);
        sessionRegistry.registerNewSession(sessionId3, (Object)principal2);
        SessionRegistryImplTests.assertEquals((Object)principal1, (Object)sessionRegistry.getAllPrincipals()[0]);
        SessionRegistryImplTests.assertEquals((Object)principal2, (Object)sessionRegistry.getAllPrincipals()[1]);
    }

    public void testSessionInformationLifecycle() throws Exception {
        String principal = "Some principal object";
        String sessionId = "1234567890";
        SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
        sessionRegistry.registerNewSession(sessionId, (Object)principal);
        Date currentDateTime = sessionRegistry.getSessionInformation(sessionId).getLastRequest();
        SessionRegistryImplTests.assertEquals((Object)principal, (Object)sessionRegistry.getSessionInformation(sessionId).getPrincipal());
        SessionRegistryImplTests.assertEquals((String)sessionId, (String)sessionRegistry.getSessionInformation(sessionId).getSessionId());
        SessionRegistryImplTests.assertNotNull((Object)sessionRegistry.getSessionInformation(sessionId).getLastRequest());
        SessionRegistryImplTests.assertEquals((int)1, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        Thread.sleep(1000L);
        sessionRegistry.refreshLastRequest(sessionId);
        Date retrieved = sessionRegistry.getSessionInformation(sessionId).getLastRequest();
        SessionRegistryImplTests.assertTrue((boolean)retrieved.after(currentDateTime));
        SessionRegistryImplTests.assertEquals((Object)retrieved, (Object)sessionRegistry.getAllSessions((Object)principal, false)[0].getLastRequest());
        sessionRegistry.removeSessionInformation(sessionId);
        SessionRegistryImplTests.assertNull((Object)sessionRegistry.getSessionInformation(sessionId));
        SessionRegistryImplTests.assertNull((Object)sessionRegistry.getAllSessions((Object)principal, false));
    }

    public void testTwoSessionsOnePrincipalExpiring() throws Exception {
        String principal = "Some principal object";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
        sessionRegistry.registerNewSession(sessionId1, (Object)principal);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        SessionRegistryImplTests.assertEquals((String)sessionId1, (String)sessionRegistry.getAllSessions((Object)principal, false)[0].getSessionId());
        sessionRegistry.registerNewSession(sessionId2, (Object)principal);
        SessionRegistryImplTests.assertEquals((int)2, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        SessionRegistryImplTests.assertEquals((String)sessionId2, (String)sessionRegistry.getAllSessions((Object)principal, false)[1].getSessionId());
        SessionInformation session = sessionRegistry.getSessionInformation(sessionId2);
        session.expireNow();
        SessionRegistryImplTests.assertTrue((boolean)sessionRegistry.getSessionInformation(sessionId2).isExpired());
        SessionRegistryImplTests.assertFalse((boolean)sessionRegistry.getSessionInformation(sessionId1).isExpired());
    }

    public void testTwoSessionsOnePrincipalHandling() throws Exception {
        String principal = "Some principal object";
        String sessionId1 = "1234567890";
        String sessionId2 = "9876543210";
        SessionRegistryImpl sessionRegistry = new SessionRegistryImpl();
        sessionRegistry.registerNewSession(sessionId1, (Object)principal);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        SessionRegistryImplTests.assertEquals((String)sessionId1, (String)sessionRegistry.getAllSessions((Object)principal, false)[0].getSessionId());
        sessionRegistry.registerNewSession(sessionId2, (Object)principal);
        SessionRegistryImplTests.assertEquals((int)2, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        SessionRegistryImplTests.assertEquals((String)sessionId2, (String)sessionRegistry.getAllSessions((Object)principal, false)[1].getSessionId());
        sessionRegistry.removeSessionInformation(sessionId1);
        SessionRegistryImplTests.assertEquals((int)1, (int)sessionRegistry.getAllSessions((Object)principal, false).length);
        SessionRegistryImplTests.assertEquals((String)sessionId2, (String)sessionRegistry.getAllSessions((Object)principal, false)[0].getSessionId());
        sessionRegistry.removeSessionInformation(sessionId2);
        SessionRegistryImplTests.assertNull((Object)sessionRegistry.getSessionInformation(sessionId2));
        SessionRegistryImplTests.assertNull((Object)sessionRegistry.getAllSessions((Object)principal, false));
    }
}

