/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.MockFilterConfig;
import org.acegisecurity.adapters.PrincipalAcegiUserToken;
import org.acegisecurity.context.HttpSessionContextIntegrationFilter;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.SecurityContextImpl;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class HttpSessionContextIntegrationFilterTests
extends TestCase {
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$org$acegisecurity$context$SecurityContextImpl;

    public HttpSessionContextIntegrationFilterTests() {
    }

    public HttpSessionContextIntegrationFilterTests(String arg0) {
        super(arg0);
    }

    private static void executeFilterInContainerSimulator(FilterConfig filterConfig, Filter filter, ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        filter.init(filterConfig);
        filter.doFilter(request, response, filterChain);
        filter.destroy();
    }

    public void testDetectsIncompatibleSessionProperties() throws Exception {
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        try {
            filter.setAllowSessionCreation(false);
            filter.setForceEagerSessionCreation(true);
            filter.afterPropertiesSet();
            HttpSessionContextIntegrationFilterTests.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            HttpSessionContextIntegrationFilterTests.assertTrue((boolean)true);
        }
        filter.setAllowSessionCreation(true);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.assertTrue((boolean)true);
    }

    public void testDetectsMissingOrInvalidContext() throws Exception {
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        try {
            filter.setContext(null);
            filter.afterPropertiesSet();
            HttpSessionContextIntegrationFilterTests.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            HttpSessionContextIntegrationFilterTests.assertTrue((boolean)true);
        }
        try {
            filter.setContext(class$java$lang$Integer == null ? (class$java$lang$Integer = HttpSessionContextIntegrationFilterTests.class$("java.lang.Integer")) : class$java$lang$Integer);
            HttpSessionContextIntegrationFilterTests.assertEquals((Object)(class$java$lang$Integer == null ? (class$java$lang$Integer = HttpSessionContextIntegrationFilterTests.class$("java.lang.Integer")) : class$java$lang$Integer), (Object)filter.getContext());
            filter.afterPropertiesSet();
            HttpSessionContextIntegrationFilterTests.fail((String)"Shown have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            HttpSessionContextIntegrationFilterTests.assertTrue((boolean)true);
        }
    }

    public void testExceptionWithinFilterChainStillClearsSecurityContextHolder() throws Exception {
        PrincipalAcegiUserToken sessionPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_ROLE")}, null);
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)sessionPrincipal);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("ACEGI_SECURITY_CONTEXT", (Object)sc);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain((Authentication)sessionPrincipal, null, new IOException());
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.afterPropertiesSet();
        try {
            HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
            HttpSessionContextIntegrationFilterTests.fail((String)"We should have received the IOException thrown inside the filter chain here");
        }
        catch (IOException ioe) {
            HttpSessionContextIntegrationFilterTests.assertTrue((boolean)true);
        }
        HttpSessionContextIntegrationFilterTests.assertEquals((Object)new SecurityContextImpl(), (Object)SecurityContextHolder.getContext());
        HttpSessionContextIntegrationFilterTests.assertNull((String)"Should have cleared FILTER_APPLIED", (Object)request.getAttribute("__acegi_session_integration_filter_applied"));
    }

    public void testExistingContextContentsCopiedIntoContextHolderFromSessionAndChangesToContextCopiedBackToSession() throws Exception {
        PrincipalAcegiUserToken sessionPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_ROLE")}, null);
        PrincipalAcegiUserToken updatedPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_DIFFERENT_ROLE")}, null);
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)sessionPrincipal);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("ACEGI_SECURITY_CONTEXT", (Object)sc);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain((Authentication)sessionPrincipal, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("ACEGI_SECURITY_CONTEXT");
        HttpSessionContextIntegrationFilterTests.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    public void testHttpSessionCreatedWhenContextHolderChanges() throws Exception {
        PrincipalAcegiUserToken updatedPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_DIFFERENT_ROLE")}, null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession(false).getAttribute("ACEGI_SECURITY_CONTEXT");
        HttpSessionContextIntegrationFilterTests.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    public void testHttpSessionEagerlyCreatedWhenDirected() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, null, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.setForceEagerSessionCreation(true);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        HttpSessionContextIntegrationFilterTests.assertNotNull((Object)request.getSession(false));
    }

    public void testHttpSessionNotCreatedUnlessContextHolderChanges() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest(null, null);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, null, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        HttpSessionContextIntegrationFilterTests.assertNull((Object)request.getSession(false));
    }

    public void testHttpSessionWithNonContextInWellKnownLocationIsOverwritten() throws Exception {
        PrincipalAcegiUserToken updatedPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_DIFFERENT_ROLE")}, null);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("ACEGI_SECURITY_CONTEXT", (Object)"NOT_A_CONTEXT_OBJECT");
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain(null, (Authentication)updatedPrincipal, null);
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.afterPropertiesSet();
        HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)filter, (ServletRequest)request, (ServletResponse)response, chain);
        SecurityContext context = (SecurityContext)request.getSession().getAttribute("ACEGI_SECURITY_CONTEXT");
        HttpSessionContextIntegrationFilterTests.assertEquals((Object)updatedPrincipal, (Object)context.getAuthentication());
    }

    public void testConcurrentThreadsLazilyChangeFilterAppliedValueToTrue() throws Exception {
        PrincipalAcegiUserToken sessionPrincipal = new PrincipalAcegiUserToken("key", "someone", "password", new GrantedAuthority[]{new GrantedAuthorityImpl("SOME_ROLE")}, null);
        SecurityContextImpl sc = new SecurityContextImpl();
        sc.setAuthentication((Authentication)sessionPrincipal);
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.getSession().setAttribute("ACEGI_SECURITY_CONTEXT", (Object)sc);
        MockHttpServletResponse response = new MockHttpServletResponse();
        HttpSessionContextIntegrationFilter filter = new HttpSessionContextIntegrationFilter();
        filter.setContext(class$org$acegisecurity$context$SecurityContextImpl == null ? (class$org$acegisecurity$context$SecurityContextImpl = HttpSessionContextIntegrationFilterTests.class$("org.acegisecurity.context.SecurityContextImpl")) : class$org$acegisecurity$context$SecurityContextImpl);
        filter.afterPropertiesSet();
        for (int i = 0; i < 3; ++i) {
            ThreadRunner runner = new ThreadRunner(request, response, filter, new MockFilterChain((Authentication)sessionPrincipal, null, null));
            runner.start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ThreadRunner
    extends Thread {
        private MockHttpServletRequest request;
        private MockHttpServletResponse response;
        private HttpSessionContextIntegrationFilter filter;
        private MockFilterChain chain;

        public ThreadRunner(MockHttpServletRequest request, MockHttpServletResponse response, HttpSessionContextIntegrationFilter filter, MockFilterChain chain) {
            this.request = request;
            this.response = response;
            this.filter = filter;
            this.chain = chain;
        }

        public void run() {
            try {
                HttpSessionContextIntegrationFilterTests.executeFilterInContainerSimulator(new MockFilterConfig(), (Filter)this.filter, (ServletRequest)this.request, (ServletResponse)this.response, this.chain);
                Assert.assertNotNull((Object)this.request.getSession(false));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class MockFilterChain
    extends TestCase
    implements FilterChain {
        private Authentication changeContextHolder;
        private Authentication expectedOnContextHolder;
        private IOException toThrowDuringChain;

        public MockFilterChain(Authentication expectedOnContextHolder, Authentication changeContextHolder, IOException toThrowDuringChain) {
            this.expectedOnContextHolder = expectedOnContextHolder;
            this.changeContextHolder = changeContextHolder;
            this.toThrowDuringChain = toThrowDuringChain;
        }

        public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            if (this.expectedOnContextHolder != null) {
                MockFilterChain.assertEquals((Object)this.expectedOnContextHolder, (Object)SecurityContextHolder.getContext().getAuthentication());
            }
            if (this.changeContextHolder != null) {
                SecurityContext sc = SecurityContextHolder.getContext();
                sc.setAuthentication(this.changeContextHolder);
                SecurityContextHolder.setContext((SecurityContext)sc);
            }
            if (this.toThrowDuringChain != null) {
                throw this.toThrowDuringChain;
            }
        }
    }
}

