/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.context.rmi;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.Authentication;
import org.acegisecurity.TargetObject;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.context.rmi.ContextPropagatingRemoteInvocation;
import org.acegisecurity.context.rmi.ContextPropagatingRemoteInvocationFactory;
import org.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.acegisecurity.util.SimpleMethodInvocation;
import org.aopalliance.intercept.MethodInvocation;

public class ContextPropagatingRemoteInvocationTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$TargetObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$acegisecurity$context$rmi$ContextPropagatingRemoteInvocationTests;

    public ContextPropagatingRemoteInvocationTests() {
    }

    public ContextPropagatingRemoteInvocationTests(String arg0) {
        super(arg0);
    }

    private ContextPropagatingRemoteInvocation getRemoteInvocation() throws Exception {
        Class clazz = class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = ContextPropagatingRemoteInvocationTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject;
        Method method = clazz.getMethod("makeLowerCase", class$java$lang$String == null ? (class$java$lang$String = ContextPropagatingRemoteInvocationTests.class$("java.lang.String")) : class$java$lang$String);
        SimpleMethodInvocation mi = new SimpleMethodInvocation(method, new Object[]{"SOME_STRING"});
        ContextPropagatingRemoteInvocationFactory factory = new ContextPropagatingRemoteInvocationFactory();
        return (ContextPropagatingRemoteInvocation)factory.createRemoteInvocation((MethodInvocation)mi);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$context$rmi$ContextPropagatingRemoteInvocationTests == null ? (class$org$acegisecurity$context$rmi$ContextPropagatingRemoteInvocationTests = ContextPropagatingRemoteInvocationTests.class$("org.acegisecurity.context.rmi.ContextPropagatingRemoteInvocationTests")) : class$org$acegisecurity$context$rmi$ContextPropagatingRemoteInvocationTests));
    }

    public void testContextIsResetEvenIfExceptionOccurs() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        try {
            remoteInvocation.setArguments(new Object[0]);
            remoteInvocation.invoke((class$org$acegisecurity$TargetObject == null ? (class$org$acegisecurity$TargetObject = ContextPropagatingRemoteInvocationTests.class$("org.acegisecurity.TargetObject")) : class$org$acegisecurity$TargetObject).newInstance());
            ContextPropagatingRemoteInvocationTests.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ContextPropagatingRemoteInvocationTests.assertNull((String)"Authentication must be null ", (Object)SecurityContextHolder.getContext().getAuthentication());
    }

    public void testNormalOperation() throws Exception {
        UsernamePasswordAuthenticationToken clientSideAuthentication = new UsernamePasswordAuthenticationToken((Object)"marissa", (Object)"koala");
        SecurityContextHolder.getContext().setAuthentication((Authentication)clientSideAuthentication);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        SecurityContextHolder.clearContext();
        ContextPropagatingRemoteInvocationTests.assertEquals((Object)"some_string org.acegisecurity.providers.UsernamePasswordAuthenticationToken false", (Object)remoteInvocation.invoke((Object)new TargetObject()));
    }

    public void testNullContextHolderDoesNotCauseInvocationProblems() throws Exception {
        SecurityContextHolder.getContext().setAuthentication(null);
        ContextPropagatingRemoteInvocation remoteInvocation = this.getRemoteInvocation();
        SecurityContextHolder.getContext().setAuthentication(null);
        ContextPropagatingRemoteInvocationTests.assertEquals((Object)"some_string Authentication empty", (Object)remoteInvocation.invoke((Object)new TargetObject()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

