/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.util.ArrayList;
import java.util.Iterator;
import junit.framework.TestCase;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocationDefinition;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionDecorator;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceMapping;
import org.acegisecurity.intercept.web.MockFilterInvocationDefinition;

public class FilterInvocationDefinitionDecoratorTest
extends TestCase {
    private FilterInvocationDefinitionDecorator decorator;
    private FilterInvocationDefinition decorated;

    protected void setUp() throws Exception {
        super.setUp();
        this.decorated = new MockFilterInvocationDefinition();
        this.decorator = new FilterInvocationDefinitionDecorator(this.decorated);
    }

    public void testFilterInvocationDefinitionMapDecorator() {
        this.decorator = new FilterInvocationDefinitionDecorator();
        this.decorator.setDecorated(this.decorated);
        FilterInvocationDefinitionDecoratorTest.assertEquals((Object)this.decorated, (Object)this.decorator.getDecorated());
    }

    public void testSetMappings() {
        ArrayList<String> roles = new ArrayList<String>();
        roles.add("ROLE_USER");
        roles.add("ROLE_ADMIN");
        FilterInvocationDefinitionSourceMapping mapping = new FilterInvocationDefinitionSourceMapping();
        mapping.setUrl("/secure/**");
        mapping.setConfigAttributes(roles);
        ArrayList<FilterInvocationDefinitionSourceMapping> mappings = new ArrayList<FilterInvocationDefinitionSourceMapping>();
        mappings.add(mapping);
        this.decorator.setMappings(mappings);
        ConfigAttributeDefinition configDefinition = new ConfigAttributeDefinition();
        Iterator it = roles.iterator();
        while (it.hasNext()) {
            String role = (String)it.next();
            configDefinition.addConfigAttribute((ConfigAttribute)new SecurityConfig(role));
        }
        it = this.decorator.getConfigAttributeDefinitions();
        int i = 0;
        while (it.hasNext()) {
            ++i;
            FilterInvocationDefinitionDecoratorTest.assertEquals((Object)configDefinition, it.next());
        }
        FilterInvocationDefinitionDecoratorTest.assertEquals((int)1, (int)i);
        FilterInvocationDefinitionDecoratorTest.assertEquals(mappings, (Object)this.decorator.getMappings());
    }
}

