/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.intercept.web;

import java.util.Iterator;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.acegisecurity.ConfigAttribute;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.MockFilterChain;
import org.acegisecurity.SecurityConfig;
import org.acegisecurity.intercept.web.FilterInvocation;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionMap;
import org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditor;
import org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class FilterInvocationDefinitionSourceEditorWithPathsTests
extends TestCase {
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorWithPathsTests;
    static /* synthetic */ Class class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap$EntryHolder;

    public FilterInvocationDefinitionSourceEditorWithPathsTests() {
    }

    public FilterInvocationDefinitionSourceEditorWithPathsTests(String arg0) {
        super(arg0);
    }

    public static void main(String[] args) {
        TestRunner.run((Class)(class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorWithPathsTests == null ? (class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorWithPathsTests = FilterInvocationDefinitionSourceEditorWithPathsTests.class$("org.acegisecurity.intercept.web.FilterInvocationDefinitionSourceEditorWithPathsTests")) : class$org$acegisecurity$intercept$web$FilterInvocationDefinitionSourceEditorWithPathsTests));
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testAntPathDirectiveIsDetected() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        FilterInvocationDefinitionMap map = (FilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertTrue((boolean)(map instanceof PathBasedFilterInvocationDefinitionMap));
    }

    public void testConvertUrlToLowercaseDefaultSettingUnchangedByEditor() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertFalse((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testConvertUrlToLowercaseSettingApplied() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("CONVERT_URL_TO_LOWERCASE_BEFORE_COMPARISON\r\nPATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertTrue((boolean)map.isConvertUrlToLowercaseBeforeComparison());
    }

    public void testInvalidNameValueFailsToParse() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        try {
            editor.setAsText("         PATTERN_TYPE_APACHE_ANT\r\n    /secure/*==ROLE_SUPERVISOR,ROLE_TELLER      \r\n");
            FilterInvocationDefinitionSourceEditorWithPathsTests.fail((String)"Shouldn't be able to use '==' for config attribute.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testIterator() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        Iterator iter = map.getConfigAttributeDefinitions();
        int counter = 0;
        while (iter.hasNext()) {
            iter.next();
            ++counter;
        }
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((int)2, (int)counter);
    }

    public void testMapReturnsNullWhenNoMatchFound() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/totally/different/path/index.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals(null, (Object)returned);
    }

    public void testMultiUrlParsing() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE\r\n/secure/*=ROLE_SUPERVISOR,ROLE_TELLER");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((int)2, (int)map.getMapSize());
    }

    public void testNoArgConstructorDoesntExist() {
        Class clazz = class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap$EntryHolder == null ? (class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap$EntryHolder = FilterInvocationDefinitionSourceEditorWithPathsTests.class$("org.acegisecurity.intercept.web.PathBasedFilterInvocationDefinitionMap$EntryHolder")) : class$org$acegisecurity$intercept$web$PathBasedFilterInvocationDefinitionMap$EntryHolder;
        try {
            clazz.getDeclaredConstructor(null);
            FilterInvocationDefinitionSourceEditorWithPathsTests.fail((String)"Should have thrown NoSuchMethodException");
        }
        catch (NoSuchMethodException expected) {
            FilterInvocationDefinitionSourceEditorWithPathsTests.assertTrue((boolean)true);
        }
    }

    public void testOrderOfEntriesIsPreservedOrderA() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/**=ROLE_WE_DONT_HAVE,ANOTHER_ROLE\r\n/secure/**=ROLE_SUPERVISOR,ROLE_TELLER");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DONT_HAVE"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ANOTHER_ROLE"));
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testOrderOfEntriesIsPreservedOrderB() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/**=ROLE_SUPERVISOR,ROLE_TELLER\r\n/secure/super/**=ROLE_WE_DONT_HAVE");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_SUPERVISOR"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_TELLER"));
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testSingleUrlParsing() throws Exception {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("PATTERN_TYPE_APACHE_ANT\r\n/secure/super/*=ROLE_WE_DONT_HAVE,ANOTHER_ROLE");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        MockHttpServletRequest httpRequest = new MockHttpServletRequest(null, null);
        httpRequest.setServletPath("/secure/super/very_secret.html");
        ConfigAttributeDefinition returned = map.getAttributes((Object)new FilterInvocation((ServletRequest)httpRequest, (ServletResponse)new MockHttpServletResponse(), (FilterChain)new MockFilterChain()));
        ConfigAttributeDefinition expected = new ConfigAttributeDefinition();
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ROLE_WE_DONT_HAVE"));
        expected.addConfigAttribute((ConfigAttribute)new SecurityConfig("ANOTHER_ROLE"));
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((Object)expected, (Object)returned);
    }

    public void testWhitespaceAndCommentsAndLinesWithoutEqualsSignsAreIgnored() {
        FilterInvocationDefinitionSourceEditor editor = new FilterInvocationDefinitionSourceEditor();
        editor.setAsText("         PATTERN_TYPE_APACHE_ANT\r\n    /secure/super/*=ROLE_WE_DONT_HAVE\r\n    /secure/*=ROLE_SUPERVISOR,ROLE_TELLER      \r\n   \r\n     \r\n   // comment line  \r\n    \r\n");
        PathBasedFilterInvocationDefinitionMap map = (PathBasedFilterInvocationDefinitionMap)editor.getValue();
        FilterInvocationDefinitionSourceEditorWithPathsTests.assertEquals((int)2, (int)map.getMapSize());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

